require 'test_helper'

class RequestLogCollectionTest < ActiveSupport::TestCase
  test "initialize" do
    service = Service.new
    docs    = []
    rlc = RequestLogCollection.new(service, docs)

    assert_equal service, rlc.service
    assert_equal [], rlc.logs
  end

  test 'logs' do
    service = Service.new
    docs    = [{ body: :b }]
    rlc = RequestLogCollection.new(service, docs)
    assert_kind_of RequestLogCollection::Item, rlc.logs.first
  end

  test 'preload_apps' do
    service   = FactoryGirl.create(:service)
    plan      = FactoryGirl.create(:application_plan, issuer: service)
    cinstance = FactoryGirl.create(:cinstance, plan: plan)
    docs = [body: { "application_id" => cinstance.application_id }]
    rlc  = RequestLogCollection.new(service, docs)

    assert_equal rlc.logs.first.application_id, cinstance.application_id
    assert_equal ({ cinstance.application_id => cinstance }), rlc.cached_apps
  end

  test 'timestamp in account timezone' do
    zone = 'Pacific Time (US & Canada)'
    Time.zone = zone
    service   = FactoryGirl.create(:service)
    service.account.timezone = zone
    service.account.save!
    docs = [body: { "timestamp" => '1986-07-29T00:00:00.000Z' }]
    rlc  = RequestLogCollection.new(service, docs)

    assert_equal rlc.logs.first.timestamp, '28 Jul 1986 17:00:00 PDT'
  end
end
