require 'test_helper'

class ProviderUserMailerTest < ActionMailer::TestCase

  test 'signup notification' do
    prepare_user_and_provider
    ProviderUserMailer.activation(@user).deliver
    email = ActionMailer::Base.deliveries.last
    body = email.body.to_s

    assert_equal '3scale Account Activation',email.subject
    assert_equal ['support@3scale.net'], email.from
    assert_match %r{Dear #{@user.informal_name}}, body
    assert_match %r{http://monkey-admin.com/p/activate/[a-z0-9]+}, body
    assert_match "The 3scale API Team.", body
  end


  test 'activation reminder' do
    prepare_user_and_provider
    ProviderUserMailer.activation_reminder(@user).deliver
    email = ActionMailer::Base.deliveries.last
    body = email.body.to_s

    assert_equal '3scale Account Activation Reminder',email.subject
    assert_equal ['support@3scale.net'], email.from
    assert_match %r{#{@user.informal_name}}, body
    assert_match %r{A couple of days ago}, body
    assert_match %r{http://monkey-admin.com/p/activate/[a-z0-9]+}, body
    assert_match "The 3scale API Team.", body
  end

  test 'lost_domain' do
    prepare_user_and_provider
    ProviderUserMailer.lost_domain('the.one.who.forgets@example.com', [@provider.domain]).deliver

    email = ActionMailer::Base.deliveries.last
    body = email.body.to_s

    assert_equal '3scale Domain Recovery', email.subject
    assert_equal ['the.one.who.forgets@example.com'], email.to
    assert_equal ['support@3scale.net'], email.from
    assert_match @provider.domain, body
  end

  private

  def prepare_user_and_provider
    ActionMailer::Base.deliveries = []
    @provider = Factory(:provider_account,
                        domain: 'api.monkey.com',
                        org_name: "Monkey",
                        self_domain: 'monkey-admin.com',
                        from_email: 'api@monkey.com')
    @user = Factory :admin, account: @provider, first_name: 'Jolly Good', last_name: 'Fellow'
  end


end
