require 'test_helper'

class Fields::FieldsTest < ActiveSupport::TestCase
  class Model < ActiveRecord::Base
    include Fields::Fields

    set_fields_source :self

    def self.columns
      []
    end

    attr_reader :provider_account

    def buyer?
      false
    end

    def master?
      true
    end

    def provider?
      true
    end

    def provider_account
      self
    end

    def fields_definitions
      FieldsDefinition.none
    end
  end

  def test_field_label
    model = Model.new
    model.stubs(new_record?: false)

    assert_equal 'Email', model.field_label('email')
  end

end
