require 'test_helper'

class Apicast::ProviderSourceTest < ActiveSupport::TestCase
  def setup
    @account = FactoryGirl.build_stubbed(:simple_provider)
    @source = Apicast::ProviderSource.new(@account)
  end

  def test_attributes_for_proxy
    time = 10.days.ago.utc

    Timecop.freeze(time) do
      assert attributes = @source.attributes_for_proxy

      assert_equal time.iso8601, attributes[:timestamp]
    end
  end

  def test_id
    assert_equal @account.id, @source.id
  end

  def test_services
    proxy = FactoryGirl.build_stubbed(:proxy)
    service = FactoryGirl.build_stubbed(:simple_service, proxy: proxy)

    @account.stubs(services: [ service ])

    assert services = @source.services.presence, 'none services'
    assert_equal @account.services.size, services.size

    service.stubs(updated_at: Time.now)
    assert_equal service.updated_at, @source.attributes_for_proxy['services'][0]['updated_at']

    assert proxy_attributes = services.first.proxy

    assert_equal proxy.hosts, proxy_attributes.hosts
    assert_equal proxy.backend.stringify_keys, proxy_attributes.backend.to_h
  end
end

