require 'test_helper'

class AccountContractTest < ActiveSupport::TestCase
  context 'plan class validation' do

    should 'be valid with an account plan' do
      account_plan = Factory :account_plan
      account_contract = AccountContract.new :plan => account_plan

      assert account_contract.valid?
    end

    should 'not be valid with an application plan' do
      app_plan = Factory :application_plan
      account_contract = AccountContract.new :plan => app_plan

      assert !account_contract.valid?
      assert_includes account_contract.errors[:plan], 'plan must be an AccountPlan'
    end

    should 'not be valid with a service plan' do
      service_plan = Factory :service_plan
      account_contract = AccountContract.new :plan => service_plan

      assert !account_contract.valid?
      assert_includes account_contract.errors[:plan], 'plan must be an AccountPlan'
    end

  end
end
