require 'test_helper'

class Abilities::MasterMemberTest < ActiveSupport::TestCase

  def setup
    @provider = FactoryGirl.build_stubbed(:simple_provider)
    @member   = FactoryGirl.build_stubbed(:member, account: @provider)

    @provider.stubs(:master?).returns(true)
  end

  def test_finance
    assert_cannot ability, :admin, :finance

    @member.admin_sections = [:finance]
    assert_can ability, :admin, :finance
  end

  private

  def ability
    Ability.new(@member)
  end
end
