module TestHelpers
  module LogRequestsAssertions

      def assert_log_empty(xml, url)
       assert_equal xml.xpath("//div[@id='log-requests-container']").size, 1
       assert_equal xml.xpath("//table[@class='log-request-transaction-table']").size, 0
      end

      def assert_log_results_by_service(xml, data, application)
        assert_equal xml.xpath("//div[@id='log-requests-container']").size, 1
        assert_equal xml.xpath("//table[@class='log-request-transaction-table']").size, data.size

        app = xml.xpath("//table[@class='log-request-transaction-table']").first.xpath(".//tbody/tr/td/a")[0]
        acc = xml.xpath("//table[@class='log-request-transaction-table']").first.xpath(".//tbody/tr/td/a")[1]

        assert_equal app.content, application.name
        assert_equal acc.content, application.account.name

        assert_equal app["href"], admin_buyers_application_path(application.id)
        assert_equal acc["href"], admin_buyers_account_path(application.account.id)
      end

      def assert_log_results_by_application(xml, data, application)
        assert_equal xml.xpath("//div[@id='log-requests-container']").size, 1
        assert_equal xml.xpath("//table[@class='log-request-transaction-table']").size, data.size
      end

  end
end
