module ApiRouting
  class FooApiController < ::Admin::Api::BaseController
    wrap_parameters :payload

    def index
      render json: {status: :success}
    end

    def create
      render json: {status: :success, name: payload_params[:name], body: payload_params[:body]}
    end

    protected

    def payload_params
      params.require(:payload).permit(:body, :name)
    end
  end

  protected

  def with_api_routes
    Rails.application.routes.draw do
      constraints MasterOrProviderDomainConstraints do
        post '/api' => 'api_routing/foo_api#create'
        get '/api' => 'api_routing/foo_api#index'
      end
    end
    yield
  ensure
    Rails.application.routes_reloader.reload!
  end
end
