require File.expand_path(File.dirname(__FILE__) + '/../test_helper')

class ContractsTest < ActionDispatch::IntegrationTest
  disable_transactional_fixtures!

  def setup
    @provider = Factory :provider_account
    @buyer = Factory :buyer_account, :provider_account => @provider

    @service_plan = Factory :service_plan, :issuer => @provider.first_service!

    @provider.set_change_service_plan_permission!(:none)
  end

  test "service contract can change plan only if live, allowed by issuer and published plan exists" do
    contract = @service_plan.create_contract_with(@buyer)
    contract.suspend!

    @provider.set_change_service_plan_permission!(:request)
    assert_equal false, contract.can_change_plan?

    @service_plan.publish!
    assert_equal false, contract.can_change_plan?

    contract.resume!
    assert_equal true, contract.can_change_plan?
  end


end
