require 'test_helper'

class Provider::ActivationsControllerTest < ActionController::TestCase

  def setup
    @provider = Factory(:provider_account)
    @user = Factory(:pending_user, account: @provider)

    host! @provider.admin_domain
  end

  test 'create' do
    get :create, activation_code: @user.activation_code

    assert_response :redirect
  end

  test 'activate a user creates onboarding process' do
    assert_equal false, @provider.onboarding.persisted?

    get :create, activation_code: @user.activation_code

    assert_equal true, @provider.reload.onboarding.persisted?
  end

end
