require 'test_helper'

class Finance::Provider::SettingsControllerTest < ActionController::TestCase

  def setup
    @provider = Factory(:provider_account, :billing_strategy => Factory(:postpaid_with_charging))
    @provider.settings.allow_finance!
    @request.host = @provider.admin_domain
  end

  test 'login is required' do
    get :show
    assert_redirected_to provider_login_url
  end

  test 'show' do
    gateway = PaymentGateway::GATEWAYS.find{|g| g.type == :authorize_net }

    PaymentGateway.stubs(:all).returns([gateway])
    login_as(@provider.admins.first)
    get :show

    assert_response :success
    # assert_template 'admin/account/payment_gateways/show'

    # assert_active_menu(:account)
    assert_equal @provider, assigns(:account)
    assert_equal [gateway], assigns(:payment_gateways)

    assert_select_form admin_account_payment_gateway_path, :method => :patch do
      assert_select 'select[name=?]', 'account[payment_gateway_type]'
      assert_select 'input[type=submit]'

      assert_select 'input[type=text][name=?]', 'account[payment_gateway_options][login]'
      assert_select 'input[type=text][name=?]', 'account[payment_gateway_options][password]'
    end
  end

  context 'gateways options' do
    should 'contain only the supported gateways' do
      login_as(@provider.admins.first)
      get :show

      assert_response :success
      page = Nokogiri::HTML::Document.parse(response.body)

      values = page.xpath(".//select[@id='account_payment_gateway_type']/*").map { |o| o["value"] }

      assert_equal(["", "authorize_net", "braintree_blue", "ogone", "stripe", "adyen12", "bogus"], values)
    end

   should 'contain the deprecated gateway payment_express only if provider already uses it' do
      @provider.update_attributes :payment_gateway_options => {
                                    :login => 'bob', :password => 'monkey',
                                  },
                                  :payment_gateway_type => :payment_express
      login_as(@provider.admins.first)
      get :show

      assert_response :success
      page = Nokogiri::HTML::Document.parse(response.body)

      values = page.xpath(".//select[@id='account_payment_gateway_type']/*").map { |o| o["value"] }

      assert_equal(["", "authorize_net", "braintree_blue", "ogone", "stripe", "adyen12", "payment_express", "bogus"], values)
   end
  end # gateway options

end
