require 'test_helper'

class Finance::Provider::LineItemsControllerTest < ActionController::TestCase

  def setup
    @provider     = Factory(:provider_account)
    @buyer        = Factory(:buyer_account, provider_account: @provider)
    @request.host = @provider.admin_domain
    @invoice      = Factory(:invoice, provider_account: @provider, buyer_account: @buyer)
    @line_item    = Factory(:line_item_plan_cost, invoice: @invoice, name: 'JohnDoe', cost: 10.0)

    login_as(@provider.admins.first)
  end

  def test_destroy_line_item
    delete :destroy, id: @line_item.id, account_id: @buyer.id, invoice_id: @invoice.id

    assert_raise(ActiveRecord::RecordNotFound) { @line_item.reload }
    assert_response :redirect
  end

  def test_destroy_line_item_xhr
    xhr :delete, :destroy, id: @line_item.id, account_id: @buyer.id, invoice_id: @invoice.id

    assert_raise(ActiveRecord::RecordNotFound) { @line_item.reload }
    assert_response :success
  end
end
