require File.expand_path(File.dirname(__FILE__) + '/../../../test_helper')

class Admin::Account::PaymentGatewaysControllerTest < ActionController::TestCase

  def setup
    @provider = Factory(:provider_account, :billing_strategy => Factory(:postpaid_with_charging))
    @provider.settings.allow_finance!
    @request.host = @provider.admin_domain
  end

  test 'update' do
    login_as(@provider.admins.first)

    put :update, :account => {
      :payment_gateway_type => 'authorize_net',
      :payment_gateway_options => {'login' => 'bob', 'password' => 'monkey'}
    }

    @provider.reload
    @provider.gateway_setting.reload
    assert_redirected_to admin_finance_settings_url
    assert_equal 'Payment gateway details were successfully saved.', flash[:notice]
    assert_equal({
      'gateway_type' => 'authorize_net',
      'gateway_settings' => {'login' => 'bob', 'password' => 'monkey'}
    },
    @provider.gateway_setting.attributes.slice('gateway_type', 'gateway_settings'))

  end
end
