#!/usr/bin/env groovy

def system = load 'system.groovy'

return { ->
    currentBuild.displayName = "#${env.BUILD_NUMBER} (${system.build_name})"

    system.node_name = 'workflow || slave'

    stage 'Build'
    system.make_build('percy')

    currentBuild.result = currentBuild.result ?: 'SUCCESS'

    system.report()
}
