import {StatsSourceCollector} from 'stats/lib/source_collector'

describe('StatsSourceCollector', () => {
  let options = {
    dateRange: {
      since: '2015-12-29T13:00:00+00:00',
      until: '2015-12-30T13:00:00+00:00',
      granularity: 'hour'
    },
    selectedMetricName: 'hits'
  }

  /*class FakeSource {
    constructor ({id, details}) {
      this.id = id
      this.details = details
    }
  }*/

  let metrics = [{ id: 7, systemName: 'hits' }]
  let methods = [{ id: 17, systemName: 'slartibartfast' }, { id: 21, systemName: 'arthur' }]

  let sourceCollector = new StatsSourceCollector({metrics, methods})

  /*beforeEach(() => {
    spyOn(StatsSourceCollector, 'Source').and.callFake(() => FakeSource)
  })*/

  it('should return the right params', () => {
    let params = sourceCollector.params(options)
    let expectedParams = {
      metric_name: 'hits',
      granularity: 'hour',
      since: '2015-12-29T13:00:00+00:00',
      until: '2015-12-30T13:00:00+00:00',
      skip_change: true
    }

    expect(params).toEqual(expectedParams)
  })

  it('should throw error on url getter', () => {
    expect(() => {
      sourceCollector.url
    }).toThrow(new Error('It should implement url getter in subclasses.'))
  })

  it('should throw error on calling getSources method', () => {
    expect(() => {
      sourceCollector.getSources()
    }).toThrow(new Error('It should implement getSources method in subclasses.'))
  })

  it('should return correct metric details', () => {
    let metricDetails = sourceCollector.getMetricDetails('hits')
    let expectedmetricDetails = [
      { id: 7, systemName: 'hits' },
      { id: 17, systemName: 'slartibartfast' },
      { id: 21, systemName: 'arthur' }
    ]

    expect(metricDetails).toEqual(expectedmetricDetails)
  })

  xit('should build the right sources', () => {
  })
})
