#!/usr/bin/env bash
set -e

SCRIPT_DIR=$(dirname "$(readlink -f $0)")

${SCRIPT_DIR}/docker.sh

# lets make everything readable by everyone
umask 0000

echo "======= Assets Precompile ======="
set -x

time bundle exec rake assets:precompile RAILS_GROUPS=assets RAILS_ENV=production
time bundle exec rake assets:precompile RAILS_GROUPS=assets RAILS_ENV=test

if [ "x$PROXY_ENABLED" == "x1" ]; then
  source "${SCRIPT_DIR}/proxy_env.sh"
fi
exec env $PROXY_ENV bundle exec rake integrate --trace
