(function() {
  var templates;

  templates = {
    backbone: "<div id='apidocs-resources-container'>\n  <h2>Operations</h2>\n  <ul id='apidocs-resources'></ul>\n</div>\n<div class='apidocs-param-tips apidocs-signin-message' style='display:none;'>\n  <p><a href='#'>Sign in</a> to your account for quick access to useful values.</p>\n</div>\n<div class='apidocs-param-tips apidocs-nothere-message' style='display:none;'>\n  <p>\n  Please view ActiveDocs from your API Admin Portal <br />\n  <strong>OR</strong> <br />\n  <a class='big-button' href='http://www.3scale.net'><small>CREATE YOUR</small> <br /> Free Account</a>\n  </p>\n</div>",
    paramTemplate: "<tr class='zebra'>\n  <td class='{{if required}}required{{/if}}'>${name}</td>\n  <td>\n    <input\n\n      {{if required}}\n        placeholder='(required)'\n        class='required'\n      {{/if}}\n\n      {{if encode}}\n        data-encode='true'\n      {{/if}}\n\n      {{if threescale_name }}\n        data-threescale-name='${threescale_name}'\n      {{/if}}\n\n      data-guid='${guid}'\n      data-param-type='${paramType}'\n      minlength='0'\n      name='${name}'\n      data-original-name='${name}'\n      type='text'\n      value='${defaultValue}'>\n      <div class='apidocs-description'>\n        ${description_inline}\n      </div>\n  </td>\n  <td>\n    <div class='apidocs-description'>\n      ${description}\n    </div>\n  </td>\n</tr>",
    paramTemplateBody: "<tr class='zebra'>\n  <td class='{{if required}}required{{/if}}'>${name}</td>\n  <td>\n    <textarea\n\n      {{if required}}\n        placeholder='(required)'\n        class='required'\n      {{/if}}\n\n      {{if threescale_name }}\n        data-threescale-name='${threescale_name}'\n      {{/if}}\n\n      data-guid='${guid}'\n      data-param-type='body'\n      name='${name}'\n      data-original-name='${name}'>${defaultValue}</textarea>\n\n      <div class='apidocs-description'>\n        ${description_inline}\n      </div>\n  </td>\n  <td>\n    <div class='apidocs-description'>\n      ${description}\n    </div>\n  </td>\n</tr>",
    paramTemplateCustom: "<tr class='zebra'>\n  <td class='code'>${name} {{if allowMultiple }} <a class='add' href='#' data-guid='${guid}'>&nbsp;</a> {{/if}}</td>\n  <td>\n    <input class='custom name' {{if threescale_name }}data-threescale-name='${threescale_name}'{{/if}} data-param-type='custom'  minlength='0' name='${name}' placeholder='name' type='text' value='' />\n    <input class='custom value' data-param-type='custom'  minlength='0' name='${name}' placeholder='value' type='text' value='' />\n    <input class='custom-hidden'  data-guid='${guid}' data-param-type='${paramType}' name='${name}' type='hidden' data-original-name='' value='' />\n   <div class='apidocs-description'>\n      ${description_inline}\n    </div\n  </td>\n  <td>\n   <div class='apidocs-description'>\n     ${description}\n   </div>\n  </td>\n</tr>",
    paramTemplateArray: "<tr class='zebra' data-name='${name}' data-count='0' data-parent='true' data-data-type='${dataType}'>\n  <td class='code'>${name} {{if allowMultiple }} <a class='add' href='#' data-guid='${guid}'>&nbsp;</a> {{/if}}</td>\n  <td>\n    <table>\n      <thead>\n        <tr>\n          <th>Parameter</th>\n          <th>Value</th>\n          <th>Description</th>\n        </tr>\n      </thead>\n      <tbody data-param-type='${paramType}' data-count='0' data-data-type='${dataType}' id='${template_id}' data-parent='true' data-guid='${guid}' data-name='${name}'>\n      </tbody>\n    </table>\n  </td>\n  <td>\n    <div class='apidocs-description'>\n      ${description}\n    </div>\n  </td>\n</tr>",
    paramTemplateSelect: "<tr>\n  <td class='code'>${name}</td>\n  <td>\n    <select name='${name}' data-param-type='${paramType}' data-original-name='${name}'>\n      {{if required == false }}\n      <option selected='selected' value=''></option>\n      {{/if}}\n      {{each allowableValues.values}}\n      {{if $value == $data.defaultValue && $data.required == true}}\n      <option selected='selected' value='${$value}'>${$value}</option>\n      {{else}}\n      <option value='${$value}'>${$value}</option>\n      {{/if}}\n      {{/each}}\n    </select>\n  </td>\n  <td>${description}</td>\n</tr>",
    resourceTemplate: "<li class='resource' id='resource_${name}'>\n  <div class='apidocs-heading operation-heading'>\n    <h2>\n      <a data-name='${name}' href='#/${name}'>${friendly_name}</a>\n    </h2>\n  </div>\n  <ul class='endpoints' id='${name}_endpoint_list' style=''></ul>\n</li>",
    apiTemplate: "<li class='endpoint'>\n  <ul class='operations' id='${name}_endpoint_operations'></ul>\n</li>",
    operationTemplate: "<li class='${httpMethodLowercase} operation' data-operation-id='${guid}'>\n  <div class='apidocs-heading' style='background-color:${groupColour}'>\n    <div class='apidocs-bubble'>\n      <div class='action'>\n        <a class='toggle'>${summary}</a>\n      </div>\n    </div>\n    <div class='path-and-method'>\n      <span class='path'><a>${path}</a></span>\n      <span class='http_method'><a>${httpMethod}</a></span>\n    </div>\n    <ul class='options' style='display:none'>\n      <li>\n        <a>${path}</a>\n      </li>\n    </ul>\n  </div>\n  <div class='content' data-operation-id='${guid}' style='display:none'>\n    {{if description}}\n    <h4>Description</h4>\n    <p>{{html description}}</p>\n    {{/if}}\n    {{if notes}}\n    <h4>Implementation Notes</h4>\n    <p>{{html notes}}</p>\n    {{/if}}\n    <form accept-charset='UTF-8' data-method='${httpMethod}' data-host='${basePath}' data-path='${path}' action='#' class='sandbox' method='post'>\n      <div style='margin:0;padding:0;display:inline'></div>\n      <table class='fullwidth'>\n        <thead>\n          <tr>\n            <th>Parameter</th>\n            <th>Value</th>\n            <th>Description</th>\n          </tr>\n        </thead>\n        <tbody id='${apiName}_${guid}_${httpMethod}_params'></tbody>\n      </table>\n      <div class='submit-bar'>\n        {{if permitted}}\n          <button class='submit' name='commit' type='button'>\n          <span>Send Request</span>\n        </button>\n        {{/if}}\n        <a href='#' data-guid='${guid}' class='hide-response' style='display:none;'>HIDE RESPONSE</a>\n      </div>\n    </form>\n    <div class='response' data-guid='${guid}' style='display:none'>\n\n      <h4 class='request_heading'>Request</h4>\n      <div class='block request_url'><pre class='prettyprint'></pre></div>\n\n      <h4 class='response_body_heading'>Response Body</h4>\n      <div class='block response_body'><pre class='prettyprint'></pre></div>\n\n      <h4>Response Code</h4>\n      <div class='block response_code'><pre></pre></div>\n\n      <h4>Response Headers</h4>\n      <div class='block response_headers'><pre class='prettyprint'></pre></div>\n\n    </div>\n  </div>\n</li>",
    paramTips: "<div class='apidocs-param-tips ${type}' style='display:none;'>\n    <p class='apidocs-tip-description'>${description}</p>\n    <ul>\n      {{each items}}\n      <li data-value='${value}'><strong>${name}</strong> <span>${value}</span></li>\n      {{/each}}\n    </ul>\n</div>"
  };

  ThreeScale.APIDocs.templates = templates;

}).call(this);
