namespace :sample do
  namespace :data do
    desc "add downloads feature to plan's features of 3scaledemo user so that setting is available on admin/service"
    task :downloads_feature => :environment do
      demo_api = Account.find_by_org_name! 'Demo API'
      demo_api.bought_cinstance.plan.features.create!(:name => 'downloads')
    end

    desc "creates sample releases"
    task :releases => :environment do
      [{ :stream => 'Linux',   :version => '1.0'},
       { :stream => 'Windows', :version => '1.0'},
       { :stream => 'Mobile',  :version => '1.0'}]
        .each do |attrs|
        r = Release.new attrs.merge(:name => "#{attrs[:stream]} #{attrs[:version]}")
        r.save!
        r.publish!
      end
    end
  end

  namespace :development do
    desc 'returns a buyer and a provider user on the same domain Params => domain (default www.3scale.net), password (default 123456)'
    task :users_paired => :environment do
      domain = ENV['domain']
      domain ||= 'www.3scale.net'
      pwd = ENV['password'] || '123456'

      provider_account = Account.find_by_domain domain
      provider_user = User.find_by_account_id provider_account.id
      provider_user.activate!
      provider_user.password = provider_user.password_confirmation = pwd
      provider_user.save!

      buyers = provider_account.buyer_users
      buyer_user = buyers.to_a.find { |b| b.account.buyer }
      buyer_user.activate!
      buyer_user.password = buyer_user.password_confirmation = pwd
      buyer_user.save!

      puts "these are your users"
      puts "provider => login #{provider_user.username} pwd #{pwd}"
      puts "buyer    => login #{buyer_user.username} pwd #{pwd}"
      puts "now visit the domain #{domain}.localhost:3000 or whatever you do to visit domains on local"
    end
  end
end
