namespace :boot do
  desc 'Tries to connect to Backend'
  task backend: :environment do
    status = ThreeScale::Core::APIClient::Resource.api(:get, {}, uri: 'status').fetch(:response_json)
    puts "Backend Internal API version #{status.fetch(:version).fetch(:backend)} status: #{status.fetch(:status)}"
  end

  desc 'Tries to connect to Mysql'
  task mysql: :environment do
    pool = ActiveRecord::Base.establish_connection
    config = pool.spec.config

    pool.with_connection do
      puts "Connected to #{config.fetch(:adapter)}://#{config.fetch(:username)}@#{config.fetch(:host){ 'localhost' }}/#{config.fetch(:database)}"
    end

    pool.disconnect!
  end

  desc 'Tries to connect to Redis'
  task redis: :environment do
    redis = System.redis
    redis.ping
    puts "Connected to #{redis.id}"
  end

  task all: %i(backend mysql redis)
end

desc 'Tries to connect to external services like Backend, DB, Redis or crashes'
task boot: 'boot:all'

Rake::Task['db:seed'].enhance(['boot:mysql'])
