module CubertLogsVisibility
  def service_cubert_info_present?
    find_service.cubert_info.present?
  end

  def provider_can_use_cubert_request_logs?
    current_account.provider_can_use?(:cubert_request_logs) && service_cubert_info_present?
  end

  def find_service
    return super if defined?(super)
    raise NoMethodError, 'find_service should be defined in controller'
  end
end
