PLANS = /account|service|application/

Given /^the (provider ".+?") has following (#{PLANS} plan)s?:$/ do |provider, plan, table|
  plan = plan.parameterize.underscore # application plan => application_plan

  table.hashes.each do |row|
    Factory plan, row.reverse_merge!(:issuer => provider.first_service!)
  end
end

Given /^a published service plan "([^\"]*)" of (service "[^\"]*" of provider "[^\"]*")$/ do |plan_name, service|
  create_plan :service, :name => plan_name, :issuer => service, :published => true
end

Given /^a default published service plan "([^\"]*)" of (service "[^\"]*" of provider "[^\"]*")$/ do |plan_name, service|
  create_plan :service, :name => plan_name, :issuer => service, :published => true, :default => true
end

Given /^a published application plan "([^\"]*)" of (service "[^\"]*" of provider "[^\"]*")$/ do |plan_name, service|
  create_plan :application, :name => plan_name, :issuer => service, :published => true
end

Given /^a default published application plan "([^\"]*)" of (service "[^\"]*" of provider "[^\"]*")$/ do |plan_name, service|
  create_plan :application, :name => plan_name, :issuer => service, :published => true, :default => true
end

Given(/^the provider has a (default )?free application plan$/) do |default|
  @free_plan ||= create_plan :application, name: 'Copper', issuer: @service, published: true, default: default.present?
end

Given(/^the provider has a (default )?paid application plan$/) do |default|
  @paid_plan ||= create_plan :application, name: 'Gold', issuer: @service, cost: 100, published: true, default: default.present?
end

Given /^(?:a|an)( default)?( published)? (#{PLANS}) plan "([^\"]*)" (?:of|for) ((?:provider|service) "[^\"]*")(?: for (\d+) monthly)?(?: exists)?$/ do |default, published, type, plan_name, issuer, cost|
  type ||= :application
  create_plan type, :name => plan_name, :issuer => issuer, :cost => cost, :default => default, :published => published
end

Given /^(buyer "[^"]*") signed up for plans? (.+)$/  do |buyer, lst|
  lst.each do |name|
    name = name.strip.delete('"')
    sign_up(buyer, name)
  end
end

Given /^(plan "[^"]*") is (published|hidden)$/ do |plan,state|
  if state == 'published'
    plan.publish! unless plan.published?
  else
    plan.hide! unless plan.hidden?
  end
end

Given /^(#{PLANS} plan "[^\"]*") requires approval(?: of contracts)?$/  do |plan|
  plan.update_attribute :approval_required, true
end

Given /^the application "([^\"]*)" of the partner "([^\"]*)" has a trial period of (\d+) days?$/  do |application_name, buyer_name, days|
  cinstance = @provider.buyers.where(org_name: buyer_name)
      .first.application_contracts.where(name: application_name).first
  cinstance.trial_period_expires_at = Time.zone.now + days.to_i.days
  cinstance.save!
end

Given(/^I want to change the plan of my application to paid$/) do
  steps %(
    Given the buyer logs in to the provider
    And I go to my application page
    And I follow "Edit #{@application.name}"
    And I follow "Change"
    And I follow "#{@paid_plan.name}"
  )
end
