Feature: API Settings
  In order to configure my API usage
  As a provider
  I want to have a nice API settings control panel

  Background:
    Given a provider "foo.example.com"
    And current domain is the admin domain of provider "foo.example.com"

  Scenario: Referrer filtering on backend v2
    Given provider "foo.example.com" uses backend v2 in his default service
      And I log in as provider "foo.example.com"
      And I go to the settings page for service "API" of provider "foo.example.com"
     And I check "Require referrer filtering"
     And I press "Update Service"
    Then I should see "Service information updated"

  @javascript
  Scenario: Changing the backend version
    Given provider "foo.example.com" uses backend v2 in his default service
    And provider "foo.example.com" has multiple applications enabled
    And a default application plan of provider "foo.example.com"
    And a buyer "bob" signed up to provider "foo.example.com"
    And buyer "bob" has application "MegaWidget"
    And I log in as provider "foo.example.com"
    And I go to the integration show page for service "API" of provider "foo.example.com"
    And I follow "edit integration settings"
    When I click on the label "API Key (user_key)"
    And I press "Update Service"
    Then I should see "Service information updated"
    And I go to the provider side "MegaWidget" application page
    Then I should see "User Key"
