# Periodic tasks code are extracted to constants so that
# it can be easily run by tests.
#
module ThreeScale
  module Jobs
    MONTH = [].freeze

    WEEK = %w(
      Pdf::Dispatch.weekly
    ).freeze

    MAGICAL_GUILLAUME_WEEKLY_JOBS = %w(
      WeeklyProviderStatsWorker.perform_async
    ).freeze

    DAILY = %w(
      Audited::Adapters::ActiveRecord::Audit.delete_old
      LogEntry.delete_old
      Cinstance.notify_about_expired_trial_periods
      Pdf::Dispatch.daily
    ).freeze

    BILLING = %w(
      Finance::BillingStrategy.daily_canaries
      Finance::BillingStrategy.daily_rest
    ).freeze

    HOUR = %w(Rails.env).freeze # just a fake job to ensure cron works

    CUSTOM = {
      86400 => # every day
      { rake: 'partners:heroku:verify_plans' } #:ruby => 'lib/tasks/resque.rb' }
    }.freeze

    def self.run(task = nil)
      yield if block_given?
    rescue => error
      System::ErrorReporting.report_error(error,
                                          component: 'job',
                                          action:     task)
      raise
    end
  end
end
