class ProviderUserMailer < ActionMailer::Base
  default from: Rails.configuration.three_scale.support_email,
          'Return-Path' => Rails.configuration.three_scale.support_email

  #TODO: dry this one
  def activation(user)
    subject = "3scale Account Activation"

    headers(
      'X-SMTPAPI' => '{"category": "Signup Notification"}'
    )

    @user = Liquid::Drops::User.new(user)

    @activate_url = provider_activate_url(activation_code: user.activation_code, host: domain(user))

    mail(
      template_name: 'activation',
      subject: subject,
      to: user.email
    )
  end

  def activation_reminder(user)
    subject = "3scale Account Activation Reminder"

    headers(
      'X-SMTPAPI' => '{"category": "Signup Notification"}'
    )

    @user = Liquid::Drops::User.new(user)
    @activate_url = provider_activate_url(activation_code: user.activation_code, host: domain(user))

    mail(
      template_name: 'activation_reminder',
      subject: subject,
      to: user.email
    )
  end

  def lost_password(user)
    @user = user
    @provider = user.account

    subject = "3scale Password Recovery"

    headers(
      'X-SMTPAPI' => '{"category": "Lost password"}'
    )

    @url = Rails.application.routes.url_helpers.provider_password_url(password_reset_token: user.lost_password_token,
                                                                     host: domain(user))
    mail(
      subject: subject,
      template_name: 'provider_lost_password',
      to: user.email
    )

  end

  def lost_domain(email, domains)
    headers(
      'X-SMTPAPI' => '{"category": "Domain Recovery"}'
    )

    @email = email
    @domains = domains

    mail(subject: "3scale Domain Recovery", to: email)
  end

  private

  def domain(user)
    account = user.account

    if account.master?
      account.domain
    elsif account.provider?
      account.admin_domain
    else
      raise "Using ProviderUserMailer for buyer account #{account.name}(#{account.id})"
    end
  end



  # TODO: The methods below aren't splitted yet - uncomment when ready.
  # ---------------------------------------------------------------------

  # def lost_password(user)
  #   self.provider_account = user.account.provider_account

  #   subject = "#{provider.name} Lost password recovery"

  #   headers(
  #           'Return-Path' => from_address(user),
  #           'X-SMTPAPI' => '{"category": "Lost password"}'
  #           )

  #   # TODO: make lost_password and provider_lost_password mailer method
  #   url = if user.account.buyer?
  #           admin_account_password_url :password_reset_token => user.lost_password_token,
  #           :host                 => domain(user)
  #         else
  #           provider_password_url :password_reset_token => user.lost_password_token,
  #           :host                 => domain(user)
  #         end

  #   assign_drops :user   => Liquid::Drops::User.new(user),
  #   :provider => Liquid::Drops::Provider.new(self.provider_account),
  #   :domain => Liquid::Drops::Deprecated.new(domain(user)),
  #   :url    => url

  #   mail(
  #        :subject => subject,
  #        :template_name => 'lost_password_email',
  #        :to => user.email,
  #        :from => from_address(user)
  #        )

  # end


  # private

  # def admin_url(user)
  #   admin_dashboard_url(:host => user.account.provider_account.domain)
  # end


  # def account_name(user)
  #   user.account.provider_account.try(:org_name) || domain(user)
  # end

end
