class Admin::Api::SsoTokensController < Admin::Api::BaseController

  wrap_parameters :sso_token, :include => [:user_id, :username, :expires_in, :redirect_url, :protocol], :format => [ :url_encoded_form ]

  # parameters:
  #   * user_id
  #   * expires_in
  #   * provider_key
  #   * protocol
  def create
    sso_token = SsoToken.new sso_token_params
    sso_token.account = site_account
    sso_token.save

    respond_with(sso_token, representer: SsoTokenRepresenter, location: nil)
  end

  private

  def sso_token_params
    params.require(:sso_token)
  end
end
