class Admin::Api::SignupsController < Admin::Api::BaseController

  # swagger
  ##~ sapi = source2swagger.namespace("Account Management API")
  #
  ##~ e = sapi.apis.add
  ##~ e.path = "/admin/api/signup.xml"
  ##~ e.responseClass = "account"

  ##~ op = e.operations.add
  ##~ op.httpMethod = "POST"
  ##~ op.summary = "Signup Express"
  ##~ op.description = "This request allows you to reproduce a sign-up from a buyer in a single API call. It will create an Account, an Admin User for the account, and optionally an Application with its keys. If the plan_id is not passed, the default plan will be used instead. You can add additional custom parameters in Fields Definition on your Admin Portal."
  ##~ op.group = "signup"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add :name => "org_name", :description => "Organization Name of the buyer account.", :dataType => "string", :allowMultiple => false, :required => true, :paramType => "query"
  ##~ op.parameters.add :name => "username", :description => "Username of the admin user (on the new buyer account).", :dataType => "string", :allowMultiple => false, :required => true, :paramType => "query"
  ##~ op.parameters.add :name => "email", :description => "Email of the admin user.", :dataType => "string", :allowMultiple => false, :required => true, :paramType => "query"
  ##~ op.parameters.add :name => "password", :description => "Password of the admin user.", :dataType => "string", :allowMultiple => false, :required => true, :paramType => "query"
  ##~ op.parameters.add @parameter_account_plan_id_by_name
  ##~ op.parameters.add @parameter_service_plan_id_by_name
  ##~ op.parameters.add @parameter_application_plan_id_by_name
  ##~ op.parameters.add @parameter_extra

  def create
    authorize!(:create, Account) if current_user

    defaults = {
      ApplicationPlan => { :name => "API signup",
                           :description => "API signup",
                           :create_origin => "api" }
    }

    Account.transaction do
      signup = current_account.signup_with_plans(plans, true, defaults) do |buyer, user|
        @buyer, @user = buyer, user

        buyer.unflattened_attributes = flat_params
        buyer.vat_rate = params[:vat_rate].to_f if params[:vat_rate]

        user.signup_type = :minimal
        user.unflattened_attributes = flat_params
      end

      if signup
        @user.activate_if_minimal_signup
      end
    end

    # FIXME: this really should not be needed
    # it should respond errors why buyer couldn't be created
    # and not respond with pathetic error
    if @buyer.errors[:plans].present?
      raise ActiveRecord::RecordNotFound
    end

    @user.errors.each do |attr, error|
      @buyer.errors.add(attr, error)
    end

    respond_with(@buyer, with_apps: true)
  end

  private

  def plans
    @plans ||= if plan_ids.present?
                 current_account.provided_plans.where(id: plan_ids)
               else
                 []
               end
  end

  def plan_ids
    [:service, :account, :application].map{|type| params["#{type}_plan_id"] }.compact
  end

end
