class Admin::Api::ServicePlansController < Admin::Api::ServiceBaseController
  wrap_parameters ServicePlan
  representer ServicePlan

  before_action :authorize_service_plans!

  # swagger (this is the unnested "fast track" route to get all service_plans)
  ##~ sapi = source2swagger.namespace("Account Management API")
  #
  ##~ e = sapi.apis.add
  ##~ e.path = "/admin/api/service_plans.xml"
  ##~ e.responseClass = "List[service_plan]"
  ##~ e.description   = "Returns a list of all your service plans."
  #
  ##~ op = e.operations.add
  ##~ op.httpMethod = "GET"
  ##~ op.summary    = "Service Plan List (all services)"
  ##~ op.description = "Returns a list of all service plans for all services. Note that service plans are scoped by service."
  ##~ op.group = "service_plan"
  #
  ##~ op.parameters.add @parameter_access_token
  #
  ##~ e = sapi.apis.add
  ##~ e.path = "/admin/api/services/{id}/service_plans.xml"
  ##~ e.responseClass = "List[service_plan]"
  #
  ##~ op = e.operations.add
  ##~ op.httpMethod = "GET"
  ##~ op.summary    = "Service Plan List"
  ##~ op.description   = "Returns a list of all service plans for a service."
  ##~ op.group = "service_plan"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_service_id_by_id
  #
  def index
    respond_with(service_plans)
  end

  #
  ##~ op = e.operations.add
  ##~ op.httpMethod = "POST"
  ##~ op.summary = "Service Plan Create"
  ##~ op.description = "Creates a new service plan in a service."
  ##~ op.group = "service_plan"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_service_id_by_id
  ##~ op.parameters.add :name => "name", :description => "Name of the service plan.", :dataType => "string", :required => true, :paramType => "query"
  ##~ op.parameters.add @parameter_system_name_by_name
  #
  def create
    service_plan = service_plans.create(service_plan_params)
    service_plan.transition_to(params[:state])

    respond_with(service_plan)
  end


  # swagger
  ##~ e = sapi.apis.add
  ##~ e.path = "/admin/api/services/{service_id}/service_plans/{id}.xml"
  ##~ e.responseClass = "service_plan"
  #
  #
  ##~ op = e.operations.add
  ##~ op.httpMethod = "GET"
  ##~ op.summary    = "Service Plan Read"
  ##~ op.description = "Returns a service plan by ID."
  ##~ op.group = "service_plan"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_service_id_by_id_name
  ##~ op.parameters.add @parameter_service_plan_id_by_id
  #
  def show
    respond_with(service_plan)
  end

  ##~ op = e.operations.add
  ##~ op.httpMethod = "PUT"
  ##~ op.summary    = "Service Plan Update"
  ##~ op.description = "Updates a service plan by ID."
  ##~ op.group = "service_plan"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_service_id_by_id_name
  ##~ op.parameters.add @parameter_service_plan_id_by_id
  ##~ op.parameters.add :name => "name", :description => "Name of the service plan.", :dataType => "string", :required => false, :paramType => "query"
  #
  def update
    service_plan.update_attributes(service_plan_params)
    service_plan.transition_to(params[:state])

    respond_with(service_plan)
  end

  ##~ op            = e.operations.add
  ##~ op.httpMethod = "DELETE"
  ##~ op.summary    = "Service Plan Delete"
  ##~ op.description = "Deletes a service plan by ID."
  ##~ op.group = "service_plan"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_service_id_by_id_name
  ##~ op.parameters.add @parameter_service_plan_id_by_id
  #
  def destroy
    service_plan.destroy

    respond_with(service_plan)
  end

  # swagger
  ##~ e = sapi.apis.add
  ##~ e.path = "/admin/api/services/{service_id}/service_plans/{id}/default.xml"
  ##~ e.responseClass = "service_plan"
  #
  ##~ op            = e.operations.add
  ##~ op.httpMethod = "PUT"
  ##~ op.summary    = "Service Plan Set to Default"
  ##~ op.description = "Sets the service plan as default. The default service plan is used when no explicit service plan is used."
  ##~ op.group = "service_plan"
  #
  ##~ op.parameters.add @parameter_access_token
  ##~ op.parameters.add @parameter_service_id_by_id_name
  ##~ op.parameters.add @parameter_service_plan_id_by_id
  #
  def default
    service.update_attribute(:default_service_plan, service_plan)

    respond_with(service_plan)
  end

  protected

  def service_plan_params
    params.fetch(:service_plan)
  end

  def service_plans
    @service_plans ||= scope.service_plans.where(issuer: accessible_services)
  end

  def service_plan
    @service_plan ||= service_plans.find(params[:id])
  end

end
