class Admin::Api::CMS::BaseController < Admin::Api::BaseController
  access_token_scopes :cms

  MAX_PER_PAGE = 100
  DEFAULT_PER_PAGE = 20

  private

  def per_page
    if params[:per_page].present?
      [params[:per_page].to_i, MAX_PER_PAGE].min
    else
      DEFAULT_PER_PAGE
    end
  end
end
