module ThreeScale
  module Backend
    module Validators
      class Referrer < Base

        # The SaaS functionality is broken. The regex used is not correct.
        # However, we cannot fix it because some clients have adapted to the
        # broken behavior.

        module SaaS
          private

          def pattern_matches?(pattern, value)
            pattern = Regexp.escape(pattern)
            pattern = pattern.gsub('\*', '.*')
            /#{pattern}/ =~ value
          end
        end
        private_constant :SaaS

        module OnPrem
          private

          def pattern_matches?(pattern, value)
            pattern = Regexp.escape(pattern)
            pattern = pattern.gsub('\*', '.*')
            /\A#{pattern}\z/ =~ value
          end
        end
        private_constant :OnPrem

        mod = ThreeScale::Backend.configuration.saas ? SaaS : OnPrem
        include(mod)

        BYPASS = '*'.freeze
        private_constant :BYPASS

        def apply
          if service.referrer_filters_required? && application.has_referrer_filters?
            if application.referrer_filters.any? { |filter| matches?(filter, params[:referrer]) }
              succeed!
            else
              fail!(ReferrerNotAllowed.new(params[:referrer]))
            end
          else
            succeed!
          end
        end

        private

        def matches?(pattern, value)
          value == BYPASS ? true : pattern_matches?(pattern, value)
        end
      end
    end
  end
end
