/*-
 *   BSD LICENSE
 *
 *   Copyright (C) 2008-2012 Daisuke Aoyama <aoyama@peach.ne.jp>.
 *   Copyright (c) Intel Corporation.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SPDK_CRC32C_H
#define SPDK_CRC32C_H

#include <stdint.h>
#include <stddef.h>
#include <sys/uio.h>

#define SPDK_CRC32C_INITIAL    0xffffffffUL
#define	SPDK_CRC32C_XOR        0xffffffffUL
#define SPDK_CRC32C_POLYNOMIAL 0x1edc6f41UL
#define SPDK_CRC32C_POLYNOMIAL_REFLECT 0x82f63b78UL

#ifdef USE_ISAL
uint32_t crc32_iscsi(const uint8_t *buf, size_t len, uint32_t crc);
#define spdk_update_crc32c(a,b,c) crc32_iscsi(a,b,c)
#else
uint32_t spdk_update_crc32c(const uint8_t *buf, size_t len, uint32_t crc);
#endif
uint32_t spdk_fixup_crc32c(size_t total, uint32_t crc);
uint32_t spdk_crc32c(const uint8_t *buf, size_t len);

#endif /* SPDK_CRC32C_H */
