/*
 IDBWrapper - A cross-browser wrapper for IndexedDB
 Copyright (c) 2011 - 2013 Jens Arps
 http://jensarps.de/

 Licensed under the MIT (X11) license
*/
(function(h,j,i){"function"===typeof define?define(j):"undefined"!==typeof module&&module.exports?module.exports=j():i[h]=j()})("IDBStore",function(){var h=function(b){throw b;},j={storeName:"Store",storePrefix:"IDBWrapper-",dbVersion:1,keyPath:"id",autoIncrement:!0,onStoreReady:function(){},onError:h,indexes:[]},i=function(b,c){"undefined"==typeof c&&"function"==typeof b&&(c=b);"[object Object]"!=Object.prototype.toString.call(b)&&(b={});for(var a in j)this[a]="undefined"!=typeof b[a]?b[a]:j[a];
this.dbName=this.storePrefix+this.storeName;this.dbVersion=parseInt(this.dbVersion,10)||1;c&&(this.onStoreReady=c);a="object"==typeof window?window:self;this.idb=a.indexedDB||a.webkitIndexedDB||a.mozIndexedDB;this.keyRange=a.IDBKeyRange||a.webkitIDBKeyRange||a.mozIDBKeyRange;this.features={hasAutoIncrement:!a.mozIndexedDB};this.consts={READ_ONLY:"readonly",READ_WRITE:"readwrite",VERSION_CHANGE:"versionchange",NEXT:"next",NEXT_NO_DUPLICATE:"nextunique",PREV:"prev",PREV_NO_DUPLICATE:"prevunique"};this.openDB()};
i.prototype={constructor:i,version:"1.4.1",db:null,dbName:null,dbVersion:null,store:null,storeName:null,keyPath:null,autoIncrement:null,indexes:null,features:null,onStoreReady:null,onError:null,_insertIdCount:0,openDB:function(){var b=this.idb.open(this.dbName,this.dbVersion),c=!1;b.onerror=function(a){var b=!1;"error"in a.target?b="VersionError"==a.target.error.name:"errorCode"in a.target&&(b=12==a.target.errorCode);if(b)this.onError(Error("The version number provided is lower than the existing one."));
else this.onError(a)}.bind(this);b.onsuccess=function(a){if(!c)if(this.db)this.onStoreReady();else if(this.db=a.target.result,"string"==typeof this.db.version)this.onError(Error("The IndexedDB implementation in this browser is outdated. Please upgrade your browser."));else if(this.db.objectStoreNames.contains(this.storeName)){this.store=this.db.transaction([this.storeName],this.consts.READ_ONLY).objectStore(this.storeName);var b=Array.prototype.slice.call(this.getIndexList());this.indexes.forEach(function(a){var e=
a.name;e?(this.normalizeIndexData(a),this.hasIndex(e)?(this.indexComplies(this.store.index(e),a)||(c=!0,this.onError(Error('Cannot modify index "'+e+'" for current version. Please bump version number to '+(this.dbVersion+1)+"."))),b.splice(b.indexOf(e),1)):(c=!0,this.onError(Error('Cannot create new index "'+e+'" for current version. Please bump version number to '+(this.dbVersion+1)+".")))):(c=!0,this.onError(Error("Cannot create index: No index name given.")))},this);b.length&&(c=!0,this.onError(Error('Cannot delete index(es) "'+
b.toString()+'" for current version. Please bump version number to '+(this.dbVersion+1)+".")));c||this.onStoreReady()}else this.onError(Error("Something is wrong with the IndexedDB implementation in this browser. Please upgrade your browser."))}.bind(this);b.onupgradeneeded=function(a){this.db=a.target.result;if(this.db.objectStoreNames.contains(this.storeName))this.store=a.target.transaction.objectStore(this.storeName);else{a={autoIncrement:this.autoIncrement};if(null!==this.keyPath)a.keyPath=this.keyPath;
this.store=this.db.createObjectStore(this.storeName,a)}var b=Array.prototype.slice.call(this.getIndexList());this.indexes.forEach(function(a){var e=a.name;e||(c=!0,this.onError(Error("Cannot create index: No index name given.")));this.normalizeIndexData(a);this.hasIndex(e)?(this.indexComplies(this.store.index(e),a)||(this.store.deleteIndex(e),this.store.createIndex(e,a.keyPath,{unique:a.unique,multiEntry:a.multiEntry})),b.splice(b.indexOf(e),1)):this.store.createIndex(e,a.keyPath,{unique:a.unique,
multiEntry:a.multiEntry})},this);b.length&&b.forEach(function(a){this.store.deleteIndex(a)},this)}.bind(this)},deleteDatabase:function(){this.idb.deleteDatabase&&this.idb.deleteDatabase(this.dbName)},put:function(b,c,a,d){null!==this.keyPath&&(d=a,a=c,c=b);d||(d=h);a||(a=k);var f=!1,e=null,g=this.db.transaction([this.storeName],this.consts.READ_WRITE);g.oncomplete=function(){(f?a:d)(e)};g.onabort=d;g.onerror=d;null!==this.keyPath?(this._addIdPropertyIfNeeded(c),b=g.objectStore(this.storeName).put(c)):
b=g.objectStore(this.storeName).put(c,b);b.onsuccess=function(a){f=!0;e=a.target.result};b.onerror=d;return g},get:function(b,c,a){a||(a=h);c||(c=k);var d=!1,f=null,e=this.db.transaction([this.storeName],this.consts.READ_ONLY);e.oncomplete=function(){(d?c:a)(f)};e.onabort=a;e.onerror=a;b=e.objectStore(this.storeName).get(b);b.onsuccess=function(a){d=!0;f=a.target.result};b.onerror=a;return e},remove:function(b,c,a){a||(a=h);c||(c=k);var d=!1,f=null,e=this.db.transaction([this.storeName],this.consts.READ_WRITE);
e.oncomplete=function(){(d?c:a)(f)};e.onabort=a;e.onerror=a;b=e.objectStore(this.storeName)["delete"](b);b.onsuccess=function(a){d=!0;f=a.target.result};b.onerror=a;return e},batch:function(b,c,a){a||(a=h);c||(c=k);"[object Array]"!=Object.prototype.toString.call(b)&&a(Error("dataArray argument must be of type Array."));var d=this.db.transaction([this.storeName],this.consts.READ_WRITE);d.oncomplete=function(){(g?c:a)(g)};d.onabort=a;d.onerror=a;var f=b.length,e=!1,g=!1,l=function(){f--;0===f&&!e&&
(g=e=!0)};b.forEach(function(b){var c=b.type,f=b.key,g=b.value,b=function(b){d.abort();e||(e=!0,a(b,c,f))};if("remove"==c)g=d.objectStore(this.storeName)["delete"](f),g.onsuccess=l,g.onerror=b;else if("put"==c)null!==this.keyPath?(this._addIdPropertyIfNeeded(g),g=d.objectStore(this.storeName).put(g)):g=d.objectStore(this.storeName).put(g,f),g.onsuccess=l,g.onerror=b},this);return d},putBatch:function(b,c,a){return this.batch(b.map(function(a){return{type:"put",value:a}}),c,a)},removeBatch:function(b,
c,a){return this.batch(b.map(function(a){return{type:"remove",key:a}}),c,a)},getBatch:function(b,c,a,d){a||(a=h);c||(c=k);d||(d="sparse");"[object Array]"!=Object.prototype.toString.call(b)&&a(Error("keyArray argument must be of type Array."));var f=this.db.transaction([this.storeName],this.consts.READ_ONLY);f.oncomplete=function(){(l?c:a)(i)};f.onabort=a;f.onerror=a;var e=[],g=b.length,l=!1,i=null,j=function(a){a.target.result||"dense"==d?e.push(a.target.result):"sparse"==d&&e.length++;g--;0===g&&
(l=!0,i=e)};b.forEach(function(b){b=f.objectStore(this.storeName).get(b);b.onsuccess=j;b.onerror=function(b){i=b;a(b);f.abort()}},this);return f},getAll:function(b,c){c||(c=h);b||(b=k);var a=this.db.transaction([this.storeName],this.consts.READ_ONLY),d=a.objectStore(this.storeName);d.getAll?this._getAllNative(a,d,b,c):this._getAllCursor(a,d,b,c);return a},_getAllNative:function(b,c,a,d){var f=!1,e=null;b.oncomplete=function(){(f?a:d)(e)};b.onabort=d;b.onerror=d;b=c.getAll();b.onsuccess=function(a){f=
!0;e=a.target.result};b.onerror=d},_getAllCursor:function(b,c,a,d){var f=[],e=!1,g=null;b.oncomplete=function(){(e?a:d)(g)};b.onabort=d;b.onerror=d;b=c.openCursor();b.onsuccess=function(a){(a=a.target.result)?(f.push(a.value),a["continue"]()):(e=!0,g=f)};b.onError=d},clear:function(b,c){c||(c=h);b||(b=k);var a=!1,d=null,f=this.db.transaction([this.storeName],this.consts.READ_WRITE);f.oncomplete=function(){(a?b:c)(d)};f.onabort=c;f.onerror=c;var e=f.objectStore(this.storeName).clear();e.onsuccess=
function(b){a=!0;d=b.target.result};e.onerror=c;return f},_addIdPropertyIfNeeded:function(b){!this.features.hasAutoIncrement&&"undefined"==typeof b[this.keyPath]&&(b[this.keyPath]=this._insertIdCount++ +Date.now())},getIndexList:function(){return this.store.indexNames},hasIndex:function(b){return this.store.indexNames.contains(b)},normalizeIndexData:function(b){b.keyPath=b.keyPath||b.name;b.unique=!!b.unique;b.multiEntry=!!b.multiEntry},indexComplies:function(b,c){return["keyPath","unique","multiEntry"].every(function(a){if("multiEntry"==
a&&void 0===b[a]&&!1===c[a])return!0;if("keyPath"==a&&"[object Array]"==Object.prototype.toString.call(c[a])){var a=c.keyPath,d=b.keyPath;if("string"==typeof d)return a.toString()==d;if(!("function"==typeof d.contains||"function"==typeof d.indexOf)||d.length!==a.length)return!1;for(var f=0,e=a.length;f<e;f++)if(!(d.contains&&d.contains(a[f])||d.indexOf(-1!==a[f])))return!1;return!0}return c[a]==b[a]})},iterate:function(b,c){var c=m({index:null,order:"ASC",autoContinue:!0,filterDuplicates:!1,keyRange:null,
writeAccess:!1,onEnd:null,onError:h},c||{}),a="desc"==c.order.toLowerCase()?"PREV":"NEXT";c.filterDuplicates&&(a+="_NO_DUPLICATE");var d=!1,f=this.db.transaction([this.storeName],this.consts[c.writeAccess?"READ_WRITE":"READ_ONLY"]),e=f.objectStore(this.storeName);c.index&&(e=e.index(c.index));f.oncomplete=function(){if(d)if(c.onEnd)c.onEnd();else b(null);else c.onError(null)};f.onabort=c.onError;f.onerror=c.onError;a=e.openCursor(c.keyRange,this.consts[a]);a.onerror=c.onError;a.onsuccess=function(a){if(a=
a.target.result){if(b(a.value,a,f),c.autoContinue)a["continue"]()}else d=!0};return f},query:function(b,c){var a=[],c=c||{};c.onEnd=function(){b(a)};return this.iterate(function(b){a.push(b)},c)},count:function(b,c){var c=m({index:null,keyRange:null},c||{}),a=c.onError||h,d=!1,f=null,e=this.db.transaction([this.storeName],this.consts.READ_ONLY);e.oncomplete=function(){(d?b:a)(f)};e.onabort=a;e.onerror=a;var g=e.objectStore(this.storeName);c.index&&(g=g.index(c.index));g=g.count(c.keyRange);g.onsuccess=
function(a){d=!0;f=a.target.result};g.onError=a;return e},makeKeyRange:function(b){var c="undefined"!=typeof b.lower,a="undefined"!=typeof b.upper,d="undefined"!=typeof b.only;switch(!0){case d:b=this.keyRange.only(b.only);break;case c&&a:b=this.keyRange.bound(b.lower,b.upper,b.excludeLower,b.excludeUpper);break;case c:b=this.keyRange.lowerBound(b.lower,b.excludeLower);break;case a:b=this.keyRange.upperBound(b.upper,b.excludeUpper);break;default:throw Error('Cannot create KeyRange. Provide one or both of "lower" or "upper" value, or an "only" value.');
}return b}};var k=function(){},n={},m=function(b,c){var a,d;for(a in c)d=c[a],d!==n[a]&&d!==b[a]&&(b[a]=d);return b};i.version=i.prototype.version;return i},this);
