/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.common.base.Objects;
import com.google.jstestdriver.requesthandlers.HttpMethod;

class RequestMatcher {
    private final HttpMethod method;
    private final String pattern;
    private final Kind kind;

    public RequestMatcher(HttpMethod method, String pattern) {
        this.method = method;
        if (pattern.startsWith("*")) {
            this.pattern = pattern.substring(1);
            this.kind = Kind.PREFIX;
        } else if (pattern.endsWith("*")) {
            this.pattern = pattern.substring(0, pattern.length() - 1);
            this.kind = Kind.SUFFIX;
        } else {
            this.pattern = pattern;
            this.kind = Kind.LITERAL;
        }
    }

    public boolean methodMatches(HttpMethod method) {
        return this.method.equals((Object)method) || this.method.equals((Object)HttpMethod.ANY);
    }

    public boolean uriMatches(String uri) {
        if (uri == null) {
            return false;
        }
        switch (this.kind) {
            case PREFIX: {
                return uri.endsWith(this.pattern);
            }
            case SUFFIX: {
                return uri.startsWith(this.pattern);
            }
        }
        return uri.equals(this.pattern);
    }

    public String getPrefix() {
        return this.kind == Kind.PREFIX ? "" : this.pattern;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.method, this.pattern, this.kind});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMatcher)) {
            return false;
        }
        RequestMatcher that = (RequestMatcher)other;
        return this.method.equals((Object)that.method) && this.pattern.equals(that.pattern) && this.kind.equals((Object)that.kind);
    }

    public String toString() {
        return "RequestMatcher [kind=" + (Object)((Object)this.kind) + ", method=" + (Object)((Object)this.method) + ", pattern=" + this.pattern + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Kind {
        PREFIX,
        SUFFIX,
        LITERAL;

    }
}

