/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.name.Named;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.FlagsParser;
import com.google.jstestdriver.JsTestDriverModule;
import com.google.jstestdriver.PathResolver;
import com.google.jstestdriver.PluginLoader;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.guice.DebugModule;
import com.google.jstestdriver.hooks.PluginInitializer;
import com.google.jstestdriver.html.HtmlDocModule;
import com.google.jstestdriver.runner.RunnerMode;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Initializer {
    private static final Logger logger = LoggerFactory.getLogger(Initializer.class);
    private final PluginLoader pluginLoader;
    private final PathResolver pathResolver;
    private final FlagsParser flagsParser;
    private final Set<PluginInitializer> initializers;
    private final PrintStream outputStream;
    private final File basePath;

    @Inject
    public Initializer(PluginLoader pluginLoader, PathResolver pathResolver, FlagsParser flagsParser, Set<PluginInitializer> initializers, @Named(value="outputStream") PrintStream outputStream, @Named(value="basePath") File basePath) {
        this.pluginLoader = pluginLoader;
        this.pathResolver = pathResolver;
        this.flagsParser = flagsParser;
        this.initializers = initializers;
        this.outputStream = outputStream;
        this.basePath = basePath;
    }

    public List<Module> initialize(List<Module> pluginModules, Configuration configuration, RunnerMode runnerMode, String[] args) {
        Flags flags = this.flagsParser.parseArgument(args);
        LinkedList<Module> modules = Lists.newLinkedList();
        Configuration resolvedConfiguration = configuration.resolvePaths(this.pathResolver, flags);
        modules.addAll(pluginModules);
        modules.addAll(this.pluginLoader.load(resolvedConfiguration.getPlugins()));
        for (PluginInitializer initializer : this.initializers) {
            Module module = initializer.initializeModule(flags, resolvedConfiguration);
            modules.add(module);
        }
        modules.add(new HtmlDocModule());
        modules.add(new DebugModule(runnerMode.isDebug()));
        String serverAddress = resolvedConfiguration.getServer(flags.getServer(), flags.getPort(), flags.getServerHandlerPrefix());
        String captureAddress = resolvedConfiguration.getCaptureAddress(serverAddress, flags.getCaptureAddress(), flags.getServerHandlerPrefix());
        modules.add(new JsTestDriverModule(flags, resolvedConfiguration.getFilesList(), serverAddress, captureAddress, this.outputStream, this.basePath, resolvedConfiguration.getTestSuiteTimeout(), resolvedConfiguration.getTests(), Collections.<FileInfo>emptyList(), resolvedConfiguration.getGatewayConfiguration()));
        return modules;
    }
}

