/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.jstestdriver.BrowserPanicResponseStream;
import com.google.jstestdriver.Response;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingResponseStreamFactory
implements ResponseStreamFactory {
    private final Set<ResponseStreamFactory> factories;

    @Inject
    public AggregatingResponseStreamFactory(Set<ResponseStreamFactory> factories) {
        this.factories = factories;
    }

    @Override
    public ResponseStream getDryRunActionResponseStream() {
        List<ResponseStream> streams = this.defaultStreams();
        for (ResponseStreamFactory factory : this.factories) {
            streams.add(factory.getDryRunActionResponseStream());
        }
        return new AggregatingResponseStream(streams);
    }

    private List<ResponseStream> defaultStreams() {
        LinkedList<ResponseStream> defaultStreams = Lists.newLinkedList();
        defaultStreams.add(new BrowserPanicResponseStream());
        return defaultStreams;
    }

    @Override
    public ResponseStream getEvalActionResponseStream() {
        List<ResponseStream> streams = this.defaultStreams();
        for (ResponseStreamFactory factory : this.factories) {
            streams.add(factory.getEvalActionResponseStream());
        }
        return new AggregatingResponseStream(streams);
    }

    @Override
    public ResponseStream getResetActionResponseStream() {
        List<ResponseStream> streams = this.defaultStreams();
        for (ResponseStreamFactory factory : this.factories) {
            streams.add(factory.getResetActionResponseStream());
        }
        return new AggregatingResponseStream(streams);
    }

    @Override
    public ResponseStream getRunTestsActionResponseStream(String browserId) {
        List<ResponseStream> streams = this.defaultStreams();
        for (ResponseStreamFactory factory : this.factories) {
            streams.add(factory.getRunTestsActionResponseStream(browserId));
        }
        return new AggregatingResponseStream(streams);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AggregatingResponseStream
    implements ResponseStream {
        private final List<ResponseStream> streams;

        public AggregatingResponseStream(List<ResponseStream> streams) {
            this.streams = streams;
        }

        @Override
        public void finish() {
            for (ResponseStream stream : this.streams) {
                stream.finish();
            }
        }

        @Override
        public void stream(Response response) {
            for (ResponseStream stream : this.streams) {
                stream.stream(response);
            }
        }

        public String toString() {
            return "AggregatingResponseStream [streams=" + this.streams + "]";
        }
    }
}

