/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.server.connector.service;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.classloader.NonDelegatingClassLoader;
import com.metamatrix.common.classloader.URLFilteringClassLoader;
import com.metamatrix.common.comm.ServerListenerRegistry;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.server.ClientConnectionImpl;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.extensionmodule.protocol.URLFactory;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.util.ReflectionHelper;
import com.metamatrix.core.util.WeakObjectCache;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.datamgr.ConnectorManager;
import com.metamatrix.dqp.message.AdminRequestMessage;
import com.metamatrix.dqp.message.AdminResultsMessage;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.metadata.IndexMetadataService;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.dqp.service.metadata.SingletonMetadataCacheHolder;
import com.metamatrix.platform.resource.MessageReceiver;
import com.metamatrix.platform.service.api.CacheAdmin;
import com.metamatrix.platform.service.api.ServiceBusInterface;
import com.metamatrix.platform.service.api.ServiceID;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.platform.service.api.exception.ServiceNotInitializedException;
import com.metamatrix.platform.service.api.exception.ServiceStateException;
import com.metamatrix.platform.service.controller.AbstractService;
import com.metamatrix.platform.vm.controller.VMController;
import com.metamatrix.server.ServerPlugin;
import com.metamatrix.server.connector.service.ConnectorService;
import com.metamatrix.server.connector.service.ConnectorServiceInterface;
import com.metamatrix.server.dqp.config.PlatformConfigSource;
import com.metamatrix.server.dqp.service.PlatformTransactionService;
import com.metamatrix.server.dqp.service.PlatformVDBService;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ConnectorService
extends AbstractService
implements ConnectorServiceInterface,
CacheAdmin {
    private static final String RESULT_SET_CACHE_NAME = "ConnectorResultSetCache";
    private ConnectorManager connectorMgr;
    private Map sessionToClientConnection = Collections.synchronizedMap(new HashMap());
    private String connectorMgrName;
    private boolean monitoringEnabled = true;
    private static boolean cacheClassLoaders = true;
    private static WeakObjectCache classLoaderCache = new WeakObjectCache();
    static /* synthetic */ Class class$com$metamatrix$common$extensionmodule$ExtensionModuleEvent;
    static /* synthetic */ Class class$com$metamatrix$server$connector$service$ConnectorService;

    private static void initExtensionModuleListener() {
        VMMessageBus vmb = new VMMessageBus();
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        try {
            vmb.addListener(class$com$metamatrix$common$extensionmodule$ExtensionModuleEvent == null ? (class$com$metamatrix$common$extensionmodule$ExtensionModuleEvent = ConnectorService.class$("com.metamatrix.common.extensionmodule.ExtensionModuleEvent")) : class$com$metamatrix$common$extensionmodule$ExtensionModuleEvent, (EventObjectListener)listener);
        }
        catch (MessagingException e) {
            ServerPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    public void init(ServiceID id, DeployedComponentID deployedComponentID, Properties props, ServiceBusInterface controller, ServerListenerRegistry listenerRegistry) throws ServiceException {
        super.init(id, deployedComponentID, props, controller, listenerRegistry);
        String monitoringEnabledString = this.getProperties().getProperty("ServiceMonitoringEnabled");
        if (monitoringEnabledString != null) {
            this.monitoringEnabled = Boolean.valueOf(monitoringEnabledString);
        }
        ConnectorService.logOK("ConnectorService.Data_source_monitoring_enabled", new Boolean(this.monitoringEnabled));
    }

    public ConnectorID getConnectorID() throws ServiceStateException {
        this.checkState();
        if (this.connectorMgr == null || this.connectorMgr.getConnectorID() == null) {
            throw new ServiceNotInitializedException(ServerPlugin.Util.getString("ConnectorService.This_connector_service_is_not_yet_ready."));
        }
        return this.connectorMgr.getConnectorID();
    }

    private ClassLoader getCustomClassLoader(String urls) throws ApplicationInitializationException {
        if (urls == null || urls.trim().length() == 0) {
            String msg = ServerPlugin.Util.getString("ConnectorService.NoClassPath");
            ServerPlugin.Util.log(4, msg);
            throw new ApplicationInitializationException(4, msg);
        }
        Class clazz = class$com$metamatrix$server$connector$service$ConnectorService == null ? (class$com$metamatrix$server$connector$service$ConnectorService = ConnectorService.class$("com.metamatrix.server.connector.service.ConnectorService")) : class$com$metamatrix$server$connector$service$ConnectorService;
        synchronized (clazz) {
            NonDelegatingClassLoader result = (NonDelegatingClassLoader)classLoaderCache.get((Object)urls);
            if (result != null) {
                return result;
            }
            try {
                result = new URLFilteringClassLoader(URLFactory.parseURLs((String)urls, (String)";"));
                if (cacheClassLoaders) {
                    classLoaderCache.put((Object)urls, (Object)result);
                }
                return result;
            }
            catch (MalformedURLException e1) {
                String msg = ServerPlugin.Util.getString("ConnectorService.IllegalClassPath");
                ServerPlugin.Util.log(4, msg);
                throw new ApplicationInitializationException(4, msg);
            }
        }
    }

    private ConnectorManager createConnectorManager(Properties deMaskedProps, ClassLoader loader) throws ApplicationLifecycleException, ApplicationInitializationException {
        try {
            Class mgrClass = ReflectionHelper.loadClass((String)"com.metamatrix.dqp.internal.datamgr.impl.ConnectorManagerImpl", (ClassLoader)loader);
            ConnectorManager connectorManager = (ConnectorManager)mgrClass.newInstance();
            ServiceID id = this.getID();
            String connID = "" + id.getVMControllerID().getID() + "|" + id.getID();
            deMaskedProps.put("ConnectorID", connID);
            deMaskedProps.put("ConnectorBindingName", this.getInstanceName());
            deMaskedProps.put("ConnectorClassLoader", loader);
            deMaskedProps.put("ConnectorVMName", VMController.getVMName());
            connectorManager.initialize(deMaskedProps);
            return connectorManager;
        }
        catch (MetaMatrixCoreException e) {
            String msg = ServerPlugin.Util.getString("ConnectorService.Unexpected_error_instantiating_ConnectorManagerImpl");
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw new ApplicationLifecycleException((Throwable)e, 4, msg);
        }
        catch (InstantiationException e) {
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_instantiate_ConnectorManagerImpl");
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw new ApplicationLifecycleException((Throwable)e, 4, msg);
        }
        catch (IllegalAccessException e) {
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_access_ConnectorManagerImpl");
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw new ApplicationLifecycleException((Throwable)e, 4, msg);
        }
    }

    protected void initService(Properties props) throws ApplicationLifecycleException, ApplicationInitializationException {
        Properties deMaskedProps = this.decryptMaskedProperties(props);
        String urls = deMaskedProps.getProperty("ConnectorClassPath");
        ClassLoader loader = this.getCustomClassLoader(urls);
        this.connectorMgr = this.createConnectorManager(deMaskedProps, loader);
        try {
            PlatformVDBService vdbSerice = new PlatformVDBService();
            vdbSerice.initialize(new Properties());
            this.connectorMgr.installService("dqp.vdb", (ApplicationService)vdbSerice);
            IndexMetadataService metadataSvc = this.getIndexMetadataService();
            this.connectorMgr.installService("dqp.metadata", (ApplicationService)metadataSvc);
            ApplicationService dts = PlatformConfigSource.getTrackingService();
            this.connectorMgr.installService("dqp.tracking", dts);
            PlatformTransactionService pts = new PlatformTransactionService();
            pts.initialize(new Properties());
            this.connectorMgr.installService("dqp.transaction", (ApplicationService)pts);
            this.connectorMgr.start();
            this.connectorMgrName = this.connectorMgr.getName();
        }
        catch (ApplicationInitializationException e) {
            this.killService();
            throw e;
        }
        catch (ApplicationLifecycleException e) {
            this.killService();
            throw e;
        }
    }

    private IndexMetadataService getIndexMetadataService() throws ApplicationInitializationException {
        QueryMetadataCache sharedCache = null;
        try {
            String systemVbdUrl = CurrentConfiguration.getProperty((String)"metamatrix.server.metadata.systemURL");
            if (systemVbdUrl == null) {
                throw new ApplicationInitializationException(ServerPlugin.Util.getString("ConnectorService.1"));
            }
            URL systemUrl = URLFactory.parseURL((String)systemVbdUrl);
            sharedCache = SingletonMetadataCacheHolder.getMetadataCache((URL)systemUrl);
        }
        catch (Exception e) {
            throw new ApplicationInitializationException((Throwable)e, ServerPlugin.Util.getString("ConnectorService.0"));
        }
        IndexMetadataService metadataSvc = new IndexMetadataService(sharedCache);
        metadataSvc.initialize(new Properties());
        return metadataSvc;
    }

    protected void closeService() throws ApplicationLifecycleException {
        this.waitForServiceToClear();
        if (this.connectorMgr != null) {
            try {
                Object[] params = new Object[]{this.connectorMgrName};
                ServerPlugin.Util.log(1, ServerPlugin.Util.getString("ConnectorService.Shuting_down_connectorMgr", params));
                this.connectorMgr.stop();
            }
            catch (ApplicationLifecycleException e) {
                Object[] params = new Object[]{this.connectorMgrName, e.getMessage()};
                String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_shutdown_connectorMgr", params);
                ServerPlugin.Util.log(4, (Throwable)e, msg);
                throw new ApplicationLifecycleException(4, msg);
            }
            finally {
                this.connectorMgr = null;
            }
        }
    }

    protected void waitForServiceToClear() throws ApplicationLifecycleException {
        if (this.connectorMgr != null) {
            Object[] params = new Object[]{this.connectorMgrName};
            ServerPlugin.Util.log(1, ServerPlugin.Util.getString("ConnectorService.Waiting_for_ConnectorManager_[{0}]_queue_to_clear.", params));
            this.connectorMgr.clearPool(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killService() {
        if (this.connectorMgr != null) {
            try {
                Object[] params = new Object[]{this.connectorMgrName};
                ServerPlugin.Util.log(1, ServerPlugin.Util.getString("ConnectorService.Killing_connectorMgr", params));
                this.connectorMgr.clearPool(true);
                this.connectorMgr.stop();
            }
            catch (ApplicationLifecycleException e) {
                Object[] params = new Object[]{this.connectorMgrName, e.getMessage()};
                ServerPlugin.Util.log(4, (Throwable)e, ServerPlugin.Util.getString("ConnectorService.Unable_to_shutdown_connectorMgr", params));
            }
            finally {
                this.connectorMgr = null;
            }
        }
    }

    public void checkState() throws ServiceStateException {
        if (this.monitoringEnabled) {
            ConnectionStatus status = this.connectorMgr.getStatus();
            int state = this.getCurrentState();
            if (state == 1 && status.getStatus().equals((Object)AliveStatus.DEAD)) {
                this.changeState(6);
                ConnectorService.logOK("ConnectorService.Change_state_to_data_source_unavailable", this.connectorMgrName);
            }
            if (state == 6 && status.getStatus().equals((Object)AliveStatus.ALIVE)) {
                this.changeState(1);
                ConnectorService.logOK("ConnectorService.Change_state_to_open", this.connectorMgrName);
            }
        }
        super.checkState();
    }

    public void send(Message message, String messageKey, Object clientIdentifier) {
        try {
            this.checkState();
        }
        catch (ServiceStateException e) {
            ResultsMessage failureMsg = this.createFailureResultMsg(message, e);
            ServerPlugin.Util.log(4, (Throwable)failureMsg.getException(), ServerPlugin.Util.getString("ConnectorService.Unable_to_execute_request_on_connector_manager."));
            this.sendFailure((ClientConnection)this.sessionToClientConnection.get(clientIdentifier), failureMsg, messageKey);
            return;
        }
        if (this.connectorMgr == null || this.connectorMgr.getConnectorID() == null) {
            ServiceNotInitializedException e = new ServiceNotInitializedException(ServerPlugin.Util.getString("ConnectorService.This_connector_service_is_not_yet_ready."));
            ResultsMessage failureMsg = this.createFailureResultMsg(message, (Throwable)e);
            ServerPlugin.Util.log(4, (Throwable)failureMsg.getException(), ServerPlugin.Util.getString("ConnectorService.Unable_to_execute_request_on_connector_manager."));
            this.sendFailure((ClientConnection)this.sessionToClientConnection.get(clientIdentifier), failureMsg, messageKey);
            return;
        }
        ClientConnection clientConn = (ClientConnection)this.sessionToClientConnection.get(clientIdentifier);
        if (ServerPlugin.DEBUG) {
            Object[] params = new Object[]{clientIdentifier, clientConn.getConnectionProperty("connectionID"), message};
            ServerPlugin.Util.log(1, ServerPlugin.Util.getString("ConnectorServerConnection.send_async2", params));
        }
        this.connectorMgr.receive(clientConn, message, messageKey);
    }

    public Message send(Message message, Object clientIdentifier) throws ApplicationException {
        try {
            this.checkState();
        }
        catch (ServiceStateException e) {
            ResultsMessage failureMsg = this.createFailureResultMsg(message, e);
            ServerPlugin.Util.log(4, (Throwable)failureMsg.getException(), ServerPlugin.Util.getString("ConnectorService.Unable_to_execute_request_on_connector_manager."));
            return failureMsg;
        }
        if (this.connectorMgr == null || this.connectorMgr.getConnectorID() == null) {
            ServiceNotInitializedException e = new ServiceNotInitializedException(ServerPlugin.Util.getString("ConnectorService.This_connector_service_is_not_yet_ready."));
            ResultsMessage failureMsg = this.createFailureResultMsg(message, (Throwable)e);
            ServerPlugin.Util.log(4, (Throwable)failureMsg.getException(), ServerPlugin.Util.getString("ConnectorService.Unable_to_execute_request_on_connector_manager."));
            return failureMsg;
        }
        ClientConnection clientConn = (ClientConnection)this.sessionToClientConnection.get(clientIdentifier);
        if (ServerPlugin.DEBUG) {
            Object[] params = new Object[]{clientIdentifier, clientConn.getConnectionProperty("connectionID"), message};
            ServerPlugin.Util.log(1, ServerPlugin.Util.getString("ConnectorServerConnection.send_sync2", params));
        }
        return this.connectorMgr.receive(clientConn, message);
    }

    public void setMessageReceiver(MessageReceiver receiver, Properties props, Object clientIdentifier) {
        ClientConnectionImpl clientConn = new ClientConnectionImpl(receiver, props);
        if (ServerPlugin.DEBUG) {
            Object[] params = new Object[]{clientIdentifier, receiver, props};
            ServerPlugin.Util.log(1, ServerPlugin.Util.getString("ConnectorServerConnection.setMessageReceiver", params));
        }
        this.sessionToClientConnection.put(clientIdentifier, clientConn);
    }

    public Collection getQueueStatistics() {
        AdminRequestMessage aRequest = new AdminRequestMessage();
        aRequest.setRequestType(2);
        AdminResultsMessage result = null;
        try {
            if (this.connectorMgr != null) {
                result = (AdminResultsMessage)this.connectorMgr.receive((ClientConnection)new ClientConnectionImpl(null), (Message)aRequest);
            }
        }
        catch (ApplicationException e) {
            throw new MetaMatrixRuntimeException(e.getMessage());
        }
        Collection results = new ArrayList();
        if (result != null) {
            results = result.getResults();
        }
        return results;
    }

    public WorkerPoolStats getQueueStatistics(String name) {
        Object aPoolStat;
        Iterator resultsItr;
        AdminRequestMessage aRequest = new AdminRequestMessage(name);
        aRequest.setRequestType(3);
        AdminResultsMessage result = null;
        try {
            if (this.connectorMgr != null) {
                result = (AdminResultsMessage)this.connectorMgr.receive((ClientConnection)new ClientConnectionImpl(null), (Message)aRequest);
            }
        }
        catch (ApplicationException e) {
            throw new MetaMatrixRuntimeException(e.getMessage());
        }
        Collection results = null;
        WorkerPoolStats poolStats = new WorkerPoolStats();
        if (result != null && (results = result.getResults()) != null && (resultsItr = results.iterator()).hasNext() && (aPoolStat = resultsItr.next()) != null && aPoolStat instanceof WorkerPoolStats) {
            poolStats = (WorkerPoolStats)aPoolStat;
        }
        return poolStats;
    }

    private void sendFailure(ClientConnection connection, ResultsMessage failureMsg, String key) {
        try {
            connection.send((Message)failureMsg, key);
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{connection.getConnectionProperty("connectionID"), failureMsg.getException()};
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_notify_client_of_failure", params);
            ServerPlugin.Util.log(4, (Throwable)e, msg);
        }
    }

    private ResultsMessage createFailureResultMsg(Message message, Throwable e) {
        ResultsMessage failureMsg = null;
        if (message instanceof RequestMessage) {
            failureMsg = new ResultsMessage((RequestMessage)message, true);
        } else {
            RequestMessage errorRequest = new RequestMessage();
            failureMsg = new ResultsMessage(errorRequest, true);
        }
        failureMsg.setException(e);
        return failureMsg;
    }

    private Properties decryptMaskedProperties(Properties maskedProps) throws ApplicationInitializationException {
        Properties result = PropertiesUtils.clone((Properties)maskedProps, (boolean)false);
        result.remove("ServiceName");
        String connectorBindingName = maskedProps.getProperty("ServiceName");
        if (connectorBindingName == null) {
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_get_connector_binding_name_from_connector_properties");
            ApplicationInitializationException e = new ApplicationInitializationException(4, msg);
            ServerPlugin.Util.log(4, (Throwable)e, msg);
            throw e;
        }
        Configuration currentConfig = null;
        try {
            currentConfig = CurrentConfiguration.getConfiguration();
        }
        catch (ConfigurationException e) {
            Object[] params = new Object[]{connectorBindingName};
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_get_Configuration_for_connector_binding_{0}", params);
            ApplicationInitializationException e2 = new ApplicationInitializationException((Throwable)e, 4, msg);
            ServerPlugin.Util.log(4, (Throwable)e2, msg);
            throw e2;
        }
        ConfigurationModelContainer configModel = null;
        try {
            configModel = CurrentConfiguration.getConfigurationModel();
        }
        catch (ConfigurationException e) {
            Object[] params = new Object[]{connectorBindingName};
            String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_get_ConfigurationModelContainer_for_connector_binding_{0}", params);
            ApplicationInitializationException e2 = new ApplicationInitializationException((Throwable)e, 4, msg);
            ServerPlugin.Util.log(4, (Throwable)e2, msg);
            throw e2;
        }
        ConnectorBinding configConnBinding = currentConfig.getConnectorBinding(connectorBindingName);
        if (configConnBinding != null) {
            ComponentType componentType = configModel.getComponentType(configConnBinding.getComponentTypeID().getName());
            if (componentType == null) {
                Object[] params = new Object[]{configConnBinding.getComponentTypeID().getName()};
                String msg = ServerPlugin.Util.getString("ConnectorService.Unable_to_get_connector_ComponentType_for_ComponentTyepID_name_{0}", params);
                ApplicationInitializationException e = new ApplicationInitializationException(4, msg);
                ServerPlugin.Util.log(4, (Throwable)e, msg);
                throw e;
            }
            Collection compTypeDefns = componentType.getComponentTypeDefinitions();
            Iterator compTypeDefnItr = compTypeDefns.iterator();
            while (compTypeDefnItr.hasNext()) {
                ComponentTypeDefn typeDefn = (ComponentTypeDefn)compTypeDefnItr.next();
                PropertyDefinition propDefn = typeDefn.getPropertyDefinition();
                String propName = propDefn.getName();
                String propValue = maskedProps.getProperty(propName);
                if (propValue == null) continue;
                if (propDefn.isMasked()) {
                    try {
                        char[] cipherText = propValue.toCharArray();
                        char[] clearText = CryptoUtil.stringDecrypt((char[])cipherText);
                        propValue = new String(clearText);
                    }
                    catch (CryptoException e) {
                        throw new ApplicationInitializationException((Throwable)e, ServerPlugin.Util.getString("ConnectorService.Failed_decrypting_masked_prop", (Object)propName));
                    }
                }
                result.setProperty(propName, propValue);
            }
        }
        return result;
    }

    public void clientShutdown(Object clientIdentifier) throws RemoteException {
    }

    public Map getCaches() throws MetaMatrixComponentException {
        HashMap<String, String> names = new HashMap<String, String>();
        names.put(RESULT_SET_CACHE_NAME, RESULT_SET_CACHE_NAME);
        return names;
    }

    public void clearCache(String name, Properties props) throws MetaMatrixComponentException {
        if (name.equals(RESULT_SET_CACHE_NAME)) {
            AdminRequestMessage aRequest = new AdminRequestMessage();
            aRequest.setRequestType(6);
            try {
                if (this.connectorMgr != null) {
                    this.connectorMgr.receive((ClientConnection)new ClientConnectionImpl(null), (Message)aRequest);
                }
            }
            catch (ApplicationException e) {
                throw new MetaMatrixRuntimeException(e.getMessage());
            }
        }
    }

    private static synchronized void clearClassLoaderCache() {
        ServerPlugin.Util.log(0, "ConnectorService clearing ClassLoader cache");
        classLoaderCache.clear();
    }

    private static void logOK(String messageProperty, Object value) {
        Object[] params = new Object[]{value};
        ServerPlugin.Util.log(0, ServerPlugin.Util.getString(messageProperty, params));
    }

    static /* synthetic */ void access$000() {
        ConnectorService.clearClassLoaderCache();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String cacheClassLoadersString = CurrentConfiguration.getProperty((String)"metamatrix.server.cacheConnectorClassLoaders");
        if (cacheClassLoadersString != null) {
            cacheClassLoaders = Boolean.valueOf(cacheClassLoadersString);
        }
        ConnectorService.logOK("ConnectorService.Cache_class_loaders", new Boolean(cacheClassLoaders));
        ConnectorService.initExtensionModuleListener();
    }
}

