/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.xml.CriteriaCondition;
import com.metamatrix.query.processor.xml.ProcessorEnvironment;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.sql.lang.Criteria;
import java.util.List;

public class RecurseProgramCondition
extends CriteriaCondition {
    private static final int NO_LIMIT = -1;
    private static final boolean NO_EXCEPTION = false;
    private int recursionLimit;
    private boolean exceptionOnRecursionLimit;

    public RecurseProgramCondition(Program subProgramToRecurse, List resultSetNames, Criteria terminationCriteria) {
        this(subProgramToRecurse, resultSetNames, terminationCriteria, -1, false);
    }

    public RecurseProgramCondition(Program subProgramToRecurse, List resultSetNames, Criteria terminationCriteria, int recursionLimit, boolean exceptionOnRecursionLimit) {
        super(terminationCriteria, resultSetNames, subProgramToRecurse);
        this.recursionLimit = recursionLimit;
        this.exceptionOnRecursionLimit = exceptionOnRecursionLimit;
    }

    public boolean isProgramRecursive() {
        return true;
    }

    public boolean evaluate(ProcessorEnvironment env) throws BlockedException, MetaMatrixComponentException {
        boolean terminate = false;
        if (this.criteria != null) {
            terminate = super.evaluate(env);
        }
        if (!terminate && this.recursionLimit != -1) {
            boolean bl = terminate = env.getProgramRecursionCount(this.getThenProgram()) >= this.recursionLimit;
            if (terminate && this.exceptionOnRecursionLimit) {
                throw new MetaMatrixComponentException("ERR.015.006.0039", QueryExecPlugin.Util.getString("ERR.015.006.0039"));
            }
        }
        return !terminate;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("RECURSE ");
        s.append("termination Criteria ");
        s.append(this.criteria);
        s.append(", recursion limit ");
        if (this.recursionLimit == -1) {
            s.append("none");
        } else {
            s.append(this.recursionLimit);
        }
        s.append(", exception on limit ");
        s.append(this.exceptionOnRecursionLimit);
        return s.toString();
    }
}

