/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.util.ValueIteratorProvider;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class RuleBreakCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
        PlanNode critNode = this.findMultiCriteriaNode(plan);
        if (critNode == null) {
            return plan;
        }
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        LinkedList newSelectNodes = new LinkedList();
        this.filterCriteriaByGroup(crit, newSelectNodes, metadata);
        NodeEditor.replaceNode(critNode, newSelectNodes);
        List subqueryPlans = (List)critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
        List subqueryValueProviders = (List)critNode.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
        List correlatedReferences = (List)critNode.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
        if (subqueryPlans != null || correlatedReferences != null) {
            this.distributeSubqueries(newSelectNodes, subqueryPlans, subqueryValueProviders, correlatedReferences);
        }
        rules.push((OptimizerRule)this);
        return plan;
    }

    private void distributeSubqueries(List newSelectNodes, List subqueryPlans, List subqueryValueProviders, List correlatedReferences) {
        Iterator i = newSelectNodes.iterator();
        while (i.hasNext()) {
            PlanNode selectNode = (PlanNode)i.next();
            Criteria newCrit = (Criteria)selectNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            Collection subqueriesInCrit = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)newCrit);
            if (subqueriesInCrit.size() <= 0) continue;
            if (subqueryPlans != null && subqueryPlans.size() > 0) {
                Iterator valueProviderIter = subqueryValueProviders.iterator();
                Iterator planIter = subqueryPlans.iterator();
                while (valueProviderIter.hasNext()) {
                    ValueIteratorProvider valueProp = (ValueIteratorProvider)valueProviderIter.next();
                    ProcessorPlan plan = (ProcessorPlan)planIter.next();
                    Iterator critValueProps = subqueriesInCrit.iterator();
                    while (critValueProps.hasNext()) {
                        ValueIteratorProvider critValueProp = (ValueIteratorProvider)critValueProps.next();
                        if (critValueProp != valueProp) continue;
                        this.addToListProperty(selectNode, NodeConstants.Info.SUBQUERY_PLANS, plan);
                        this.addToListProperty(selectNode, NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS, valueProp);
                        valueProviderIter.remove();
                        planIter.remove();
                    }
                }
            }
            if (correlatedReferences == null || correlatedReferences.size() <= 0) continue;
            List refs = ReferenceCollectorVisitor.getReferences((LanguageObject)newCrit);
            Iterator refIter = refs.iterator();
            while (refIter.hasNext()) {
                Reference ref = (Reference)refIter.next();
                Iterator correlatedRefIter = correlatedReferences.iterator();
                while (correlatedRefIter.hasNext()) {
                    Reference correlatedRef = (Reference)correlatedRefIter.next();
                    if (ref != correlatedRef) continue;
                    this.addToListProperty(selectNode, NodeConstants.Info.CORRELATED_REFERENCES, correlatedRef);
                    correlatedRefIter.remove();
                }
            }
        }
    }

    private void addToListProperty(PlanNode selectNode, Integer listProperty, Object value) {
        ArrayList<Object> listValue = (ArrayList<Object>)selectNode.getProperty((Object)listProperty);
        if (listValue == null) {
            listValue = new ArrayList<Object>();
            selectNode.setProperty((Object)listProperty, listValue);
        }
        listValue.add(value);
    }

    PlanNode findMultiCriteriaNode(PlanNode root) throws QueryPlannerException, MetaMatrixComponentException {
        Criteria criteria;
        Boolean isHaving;
        if (root.getType() == 13 && ((isHaving = (Boolean)root.getProperty((Object)NodeConstants.Info.IS_HAVING)) == null || isHaving.equals(Boolean.FALSE)) && (criteria = (Criteria)root.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA)) != null && criteria instanceof CompoundCriteria && ((CompoundCriteria)criteria).getOperator() == 0) {
            return root;
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                PlanNode found = this.findMultiCriteriaNode(child);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    void filterCriteriaByGroup(Criteria crit, List selectNodes, QueryMetadataInterface metadata) throws QueryPlannerException, MetaMatrixComponentException {
        boolean isConjunct = true;
        CompoundCriteria multipleConjuncts = null;
        if (crit instanceof CompoundCriteria && (multipleConjuncts = (CompoundCriteria)crit).getOperator() == 0) {
            isConjunct = false;
        }
        if (isConjunct) {
            PlanNode selectNode = this.createSelectNode(crit);
            selectNodes.add(selectNode);
        } else {
            List crits = multipleConjuncts.getCriteria();
            Iterator critIter = crits.iterator();
            while (critIter.hasNext()) {
                Criteria possibleConjunct = (Criteria)critIter.next();
                this.filterCriteriaByGroup(possibleConjunct, selectNodes, metadata);
            }
        }
    }

    PlanNode createSelectNode(Criteria crit) {
        PlanNode selectNode = NodeFactory.getNewNode((int)13);
        selectNode.addGroups((Collection)this.getGroups(crit));
        selectNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)crit);
        return selectNode;
    }

    Set getGroups(Criteria crit) {
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        Iterator elementIter = elements.iterator();
        while (elementIter.hasNext()) {
            ElementSymbol elementID = (ElementSymbol)elementIter.next();
            groups.add(elementID.getGroupSymbol());
        }
        return groups;
    }

    public String toString() {
        return "BreakCriteria";
    }
}

