/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.impl.EngineStatisticsMetadata;
import org.teiid.adminapi.impl.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.TeiidOperationHandler;

class EngineStatistics
extends TeiidOperationHandler {
    protected EngineStatistics() {
        super("engine-statistics");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        EngineStatisticsMetadata stats = new EngineStatisticsMetadata();
        try {
            BufferManagerService bufferMgrSvc = this.getBufferManager(context);
            stats.setSessionCount(this.getSessionCount(context));
            stats.setTotalMemoryUsedInKB(bufferMgrSvc.getHeapCacheMemoryInUseKB());
            stats.setMemoryUsedByActivePlansInKB(bufferMgrSvc.getHeapMemoryInUseByActivePlansKB());
            stats.setDiskWriteCount(bufferMgrSvc.getDiskWriteCount());
            stats.setDiskReadCount(bufferMgrSvc.getDiskReadCount());
            stats.setCacheReadCount(bufferMgrSvc.getCacheReadCount());
            stats.setCacheWriteCount(bufferMgrSvc.getCacheWriteCount());
            stats.setDiskSpaceUsedInMB(bufferMgrSvc.getUsedDiskBufferSpaceMB());
            stats.setActivePlanCount(engine.getActivePlanCount());
            stats.setWaitPlanCount(engine.getWaitingPlanCount());
            stats.setMaxWaitPlanWaterMark(engine.getMaxWaitingPlanWatermark());
            VDBMetadataMapper.EngineStatisticsMetadataMapper.INSTANCE.wrap(stats, context.getResult());
        }
        catch (AdminException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.setReplyType(ModelType.LIST);
        builder.setReplyParameters(VDBMetadataMapper.EngineStatisticsMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

