/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.language.NamedTable;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.Column;
import org.teiid.translator.TranslatorException;

public class JPQLUpdateQueryVisitor
extends HierarchyVisitor {
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected AtomicInteger aliasCounter = new AtomicInteger(0);
    protected HashMap<String, String> correlatedName = new HashMap();

    public JPQLUpdateQueryVisitor() {
        super(false);
    }

    public static String getJPQLString(Command obj) throws TranslatorException {
        JPQLUpdateQueryVisitor visitor = new JPQLUpdateQueryVisitor();
        visitor.visitNode((LanguageObject)obj);
        if (!visitor.exceptions.isEmpty()) {
            throw visitor.exceptions.get(0);
        }
        return visitor.convertToQuery(obj);
    }

    private String convertToQuery(Command obj) {
        JPQLUpdateStringVisitor visitor = new JPQLUpdateStringVisitor(this);
        visitor.visitNode((LanguageObject)obj);
        return visitor.toString();
    }

    public void visit(NamedTable obj) {
        if (obj.getCorrelationName() == null) {
            String aliasName = "ql_" + this.aliasCounter.getAndIncrement();
            this.correlatedName.put(obj.getMetadataObject().getName(), aliasName);
            obj.setCorrelationName(aliasName);
        } else {
            this.correlatedName.put(obj.getMetadataObject().getName(), obj.getCorrelationName());
        }
    }

    static class JPQLUpdateStringVisitor
    extends SQLStringVisitor {
        private JPQLUpdateQueryVisitor visitor;

        public JPQLUpdateStringVisitor(JPQLUpdateQueryVisitor visitor) {
            this.visitor = visitor;
        }

        public void visit(ColumnReference column) {
            Column record = column.getMetadataObject();
            if (record != null) {
                String name = record.getProperty("assosiated_with_table", false);
                if (name == null) {
                    this.buffer.append(this.visitor.correlatedName.get(column.getTable().getMetadataObject().getName())).append(".").append(column.getMetadataObject().getName());
                } else {
                    this.buffer.append(this.visitor.correlatedName.get(name)).append(".").append(column.getMetadataObject().getName());
                }
            } else {
                this.buffer.append(column.getName());
            }
        }
    }
}

