/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.AggregationOutput;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBBaseExecution;
import org.teiid.translator.mongodb.MongoDBPlugin;

public class MongoDBDirectQueryExecution
extends MongoDBBaseExecution
implements ProcedureExecution {
    private String query;
    private List<Argument> arguments;
    protected boolean returnsArray;
    private Iterator<DBObject> results;

    public MongoDBDirectQueryExecution(List<Argument> arguments, Command cmd, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection, String nativeQuery, boolean returnsArray) {
        super(executionContext, metadata, connection);
        this.arguments = arguments;
        this.returnsArray = returnsArray;
        this.query = nativeQuery;
    }

    public void execute() throws TranslatorException {
        StringBuilder buffer = new StringBuilder();
        SQLStringVisitor.parseNativeQueryParts((String)this.query, this.arguments, (StringBuilder)buffer, (SQLStringVisitor.Substitutor)new SQLStringVisitor.Substitutor(){

            public void substitute(Argument arg, StringBuilder builder, int index) {
                Literal argumentValue = arg.getArgumentValue();
                builder.append(argumentValue.getValue());
            }
        });
        StringTokenizer st = new StringTokenizer(buffer.toString(), ";");
        String collectionName = st.nextToken();
        ArrayList<DBObject> operations = new ArrayList<DBObject>();
        while (st.hasMoreTokens()) {
            operations.add((DBObject)JSON.parse((String)st.nextToken()));
        }
        DBCollection collection = this.mongoDB.getCollection(collectionName);
        if (collection == null) {
            throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18020, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18020, new Object[]{collectionName}));
        }
        if (operations.isEmpty()) {
            throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18021, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18021, new Object[]{collectionName}));
        }
        AggregationOutput output = collection.aggregate((DBObject)operations.remove(0), operations.toArray(new DBObject[operations.size()]));
        this.results = output.results().iterator();
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        final DBObject value = this.nextRow();
        if (value == null) {
            return null;
        }
        BlobType result = new BlobType((Blob)new BlobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(JSON.serialize((Object)value).getBytes(Streamable.CHARSET));
            }
        }));
        if (this.returnsArray) {
            ArrayList<Object[]> row = new ArrayList<Object[]>(1);
            row.add(new Object[]{result});
            return row;
        }
        return Arrays.asList(result);
    }

    public DBObject nextRow() throws TranslatorException, DataNotAvailableException {
        if (this.results != null && this.results.hasNext()) {
            DBObject result = this.results.next();
            return result;
        }
        return null;
    }

    public void close() {
        this.results = null;
    }

    public void cancel() throws TranslatorException {
        this.close();
    }
}

