/*
 * Decompiled with CFR 0.152.
 */
package org.core4j.xml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.core4j.DepthFirstIterator;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.core4j.Func1;
import org.core4j.Predicates;
import org.core4j.ReadOnlyIterator;
import org.core4j.xml.XAttribute;
import org.core4j.xml.XComment;
import org.core4j.xml.XDocumentType;
import org.core4j.xml.XElement;
import org.core4j.xml.XNode;
import org.core4j.xml.XProcessingInstruction;
import org.core4j.xml.XText;
import org.core4j.xml.XmlFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class XContainer
extends XNode {
    private static final Func1<XElement, Enumerable<XElement>> CHILD_ELEMENTS = new Func1<XElement, Enumerable<XElement>>(){

        @Override
        public Enumerable<XElement> apply(XElement input) {
            return input.elements();
        }
    };
    private List<XNode> childNodes = new ArrayList<XNode>();

    protected XContainer() {
    }

    protected abstract XElement getXElement();

    protected static XElement parse(Element domElement) {
        if (domElement == null) {
            return null;
        }
        XElement rt = new XElement(domElement.getTagName(), new Object[0]);
        for (int i = 0; i < domElement.getAttributes().getLength(); ++i) {
            Attr attr = (Attr)domElement.getAttributes().item(i);
            XAttribute xatt = new XAttribute(attr.getName(), attr.getValue());
            rt.add((Object)xatt);
        }
        for (Node childNode : XContainer.domNodes(domElement.getChildNodes())) {
            XNode xchild = XContainer.parseNode(childNode);
            rt.add((Object)xchild);
        }
        return rt;
    }

    protected static XNode parseNode(Node domNode) {
        if (domNode instanceof Element) {
            return XElement.parse((Element)domNode);
        }
        if (domNode instanceof Text) {
            return new XText(((Text)domNode).getTextContent());
        }
        if (domNode instanceof Comment) {
            return new XComment(((Comment)domNode).getTextContent());
        }
        if (domNode instanceof ProcessingInstruction) {
            return new XProcessingInstruction(((ProcessingInstruction)domNode).getTarget(), ((ProcessingInstruction)domNode).getData());
        }
        if (domNode instanceof DocumentType) {
            return new XDocumentType(((DocumentType)domNode).getName(), ((DocumentType)domNode).getInternalSubset());
        }
        throw new UnsupportedOperationException("implement " + domNode);
    }

    public Enumerable<XElement> elements() {
        return this.nodes().ofType(XElement.class);
    }

    public Enumerable<XElement> elements(String name) {
        return this.nodes().ofType(XElement.class).where(Predicates.xnameEquals(name));
    }

    public XElement element(String name) {
        return this.elements().firstOrNull(Predicates.xnameEquals(name));
    }

    public Enumerable<XNode> nodes() {
        return Enumerable.create(this.childNodes);
    }

    public Enumerable<XElement> descendants() {
        return Enumerable.createFromIterator(new Func<Iterator<XElement>>(){

            @Override
            public Iterator<XElement> apply() {
                return new DepthFirstIterator<XElement>(XContainer.this.getXElement(), CHILD_ELEMENTS);
            }
        });
    }

    public Enumerable<XElement> descendants(String name) {
        return this.descendants().where(Predicates.xnameEquals(name));
    }

    void removeNode(XNode xNode) {
        this.childNodes.remove(xNode);
    }

    public void add(Object ... content) {
        for (Object obj : content) {
            this.add(obj);
        }
    }

    public void add(Object content) {
        XNode node = null;
        if (content instanceof XNode) {
            node = (XNode)content;
        }
        if (content instanceof String) {
            node = new XText((String)content);
        }
        if (node == null) {
            throw new UnsupportedOperationException("Unknown content: " + content);
        }
        this.childNodes.add(node);
        if (this instanceof XElement) {
            node.setParent((XElement)this);
        }
    }

    public String toString() {
        return this.getXElement().toString();
    }

    @Override
    public String toString(XmlFormat format) {
        return this.getXElement().toString(format);
    }

    protected static Enumerable<Node> domNodes(final NodeList nodes) {
        return Enumerable.createFromIterator(new Func<Iterator<Node>>(){

            @Override
            public Iterator<Node> apply() {
                return new NodeListIterator(nodes);
            }
        });
    }

    private static Enumerable<Element> domElements(Element parent) {
        return XContainer.domNodes(parent.getChildNodes()).ofType(Element.class);
    }

    protected static String domPrettyPrint(Node xml, int indent) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XContainer.domPrettyPrint(xml, indent, baos);
        try {
            return new String(baos.toByteArray(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void domPrettyPrint(Node xml, int indent, OutputStream out) {
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            tf.transform(new DOMSource(xml), new StreamResult(out));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class NodeListIterator
    extends ReadOnlyIterator<Node> {
        private final NodeList nodes;
        private int index = 0;

        public NodeListIterator(NodeList nodes) {
            this.nodes = nodes;
        }

        @Override
        protected ReadOnlyIterator.IterationResult<Node> advance() throws Exception {
            Node node;
            if ((node = this.nodes.item(this.index++)) == null) {
                return ReadOnlyIterator.IterationResult.done();
            }
            return ReadOnlyIterator.IterationResult.next(node);
        }
    }
}

