/*
 * Decompiled with CFR 0.152.
 */
package org.core4j;

import java.util.Iterator;
import java.util.Stack;
import org.core4j.Enumerable;
import org.core4j.Func1;
import org.core4j.ReadOnlyIterator;

public class DepthFirstIterator<T>
extends ReadOnlyIterator<T> {
    private final Func1<T, Enumerable<T>> childrenFn;
    private final Stack<T> stack = new Stack();

    public DepthFirstIterator(T startingNode, Func1<T, Enumerable<T>> childrenFn) {
        this.childrenFn = childrenFn;
        this.stack.add(startingNode);
    }

    @Override
    protected ReadOnlyIterator.IterationResult<T> advance() throws Exception {
        Iterator<T> i$ = this.childrenFn.apply(this.stack.peek()).iterator();
        if (i$.hasNext()) {
            T child = i$.next();
            this.stack.push(child);
            return ReadOnlyIterator.IterationResult.next(child);
        }
        while (this.stack.size() > 1) {
            T currentNode = this.stack.pop();
            boolean foundSelf = false;
            for (T sibling : this.childrenFn.apply(this.stack.peek())) {
                if (foundSelf) {
                    this.stack.push(sibling);
                    return ReadOnlyIterator.IterationResult.next(sibling);
                }
                if (!sibling.equals(currentNode)) continue;
                foundSelf = true;
            }
        }
        return ReadOnlyIterator.IterationResult.done();
    }
}

