/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ResolvePathHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "resolve-path";
    public static final SimpleAttributeDefinition RELATIVE_TO_ONLY = SimpleAttributeDefinitionBuilder.create("relative-to-only", ModelType.BOOLEAN, true).build();
    private static final SimpleOperationDefinition DEFAULT_OPERATION_DEFINITION = new SimpleOperationDefinitionBuilder("resolve-path", new ResolvePathResourceDescriptionResolver("resolve-path")).addParameter(RELATIVE_TO_ONLY).setReplyType(ModelType.STRING).build();
    private final AttributeDefinition parentAttribute;
    private final AttributeDefinition relativeToAttribute;
    private final AttributeDefinition pathAttribute;
    private final OperationDefinition operationDefinition;
    private final PathManager pathManager;

    private ResolvePathHandler(OperationDefinition operationDefinition, AttributeDefinition parentAttribute, AttributeDefinition relativeToAttribute, AttributeDefinition pathAttribute, PathManager pathManager) {
        this.parentAttribute = parentAttribute;
        this.relativeToAttribute = relativeToAttribute;
        this.pathAttribute = pathAttribute;
        this.operationDefinition = operationDefinition;
        this.pathManager = pathManager;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String result;
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        ModelNode relativeToOnly = RELATIVE_TO_ONLY.validateOperation(operation);
        boolean resolveRelativeToOnly = relativeToOnly.asBoolean(false);
        ModelNode file = this.parentAttribute != null ? this.parentAttribute.resolveModelAttribute(context, model) : model;
        ModelNode relativeTo = this.relativeToAttribute.resolveModelAttribute(context, file);
        ModelNode path = this.pathAttribute.resolveModelAttribute(context, file);
        if (relativeTo.isDefined()) {
            result = !resolveRelativeToOnly && path.isDefined() ? this.pathManager.resolveRelativePathEntry(path.asString(), relativeTo.asString()) : this.pathManager.getPathEntry(relativeTo.asString()).resolvePath();
        } else if (path.isDefined()) {
            result = this.pathManager.resolveRelativePathEntry(path.asString(), null);
        } else {
            throw ControllerMessages.MESSAGES.noPathToResolve(this.relativeToAttribute.getName(), this.pathAttribute.getName(), model);
        }
        context.getResult().set(new ModelNode(result));
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public OperationDefinition getOperationDefinition() {
        return this.operationDefinition;
    }

    private static String getBundleKey() {
        return String.format("%s.%s", "path", OPERATION_NAME);
    }

    private static String getBundleKey(String key) {
        return String.format("%s.%s.%s", "path", OPERATION_NAME, key);
    }

    private static class ResolvePathResourceDescriptionResolver
    extends StandardResourceDescriptionResolver {
        private final String operationName;

        public ResolvePathResourceDescriptionResolver(String operationName) {
            super("path", ControllerResolver.RESOURCE_NAME, ResolvePathHandler.class.getClassLoader(), false, false);
            this.operationName = operationName;
        }

        @Override
        public String getOperationDescription(String operationName, Locale locale, ResourceBundle bundle2) {
            if (this.operationName.equals(operationName)) {
                return bundle2.getString(ResolvePathHandler.getBundleKey());
            }
            return super.getOperationParameterDescription(operationName, operationName, locale, bundle2);
        }

        @Override
        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
            if (this.operationName.equals(operationName)) {
                return bundle2.getString(ResolvePathHandler.getBundleKey(paramName));
            }
            return super.getOperationParameterDescription(operationName, paramName, locale, bundle2);
        }

        @Override
        public String getOperationReplyDescription(String operationName, Locale locale, ResourceBundle bundle2) {
            if (this.operationName.equals(operationName)) {
                return bundle2.getString(ResolvePathHandler.getBundleKey("reply"));
            }
            return super.getOperationReplyDescription(operationName, locale, bundle2);
        }
    }

    public static class Builder {
        private final PathManager pathManager;
        private final OperationDefinition operationDefinition;
        private AttributeDefinition parentAttribute;
        private AttributeDefinition relativeToAttribute;
        private AttributeDefinition pathAttribute;

        private Builder(OperationDefinition operationDefinition, PathManager pathManager) {
            this.operationDefinition = operationDefinition;
            this.pathManager = pathManager;
        }

        public static Builder of(PathManager pathManager) {
            if (pathManager == null) {
                throw ControllerMessages.MESSAGES.nullVar("pathManager");
            }
            return new Builder(DEFAULT_OPERATION_DEFINITION, pathManager);
        }

        @Deprecated
        public static Builder of(String operationName, PathManager pathManager) {
            if (pathManager == null) {
                throw ControllerMessages.MESSAGES.nullVar("pathManager");
            }
            if (operationName == null) {
                throw ControllerMessages.MESSAGES.nullVar("operationName");
            }
            SimpleOperationDefinition operationDefinition = new SimpleOperationDefinitionBuilder(operationName, new ResolvePathResourceDescriptionResolver(operationName)).addParameter(RELATIVE_TO_ONLY).setReplyType(ModelType.STRING).build();
            return new Builder(operationDefinition, pathManager);
        }

        public ResolvePathHandler build() {
            if (this.relativeToAttribute == null) {
                this.relativeToAttribute = PathResourceDefinition.RELATIVE_TO;
            }
            if (this.pathAttribute == null) {
                this.pathAttribute = PathResourceDefinition.PATH;
            }
            return new ResolvePathHandler(this.operationDefinition, this.parentAttribute, this.relativeToAttribute, this.pathAttribute, this.pathManager);
        }

        public Builder setParentAttribute(AttributeDefinition parentAttribute) {
            this.parentAttribute = parentAttribute;
            return this;
        }

        public Builder setRelativeToAttribute(AttributeDefinition relativeToAttribute) {
            this.relativeToAttribute = relativeToAttribute;
            return this;
        }

        public Builder setPathAttribute(AttributeDefinition pathAttribute) {
            this.pathAttribute = pathAttribute;
            return this;
        }
    }
}

