/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.permission;

import java.security.Permission;
import java.util.List;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.permission.ManagementPermission;

public class SimpleManagementPermission
extends ManagementPermission {
    private final Constraint[] constraints;

    public SimpleManagementPermission(Action.ActionEffect actionEffect, List<Constraint> constraints) {
        this(actionEffect, constraints.toArray(new Constraint[constraints.size()]));
    }

    public SimpleManagementPermission(Action.ActionEffect actionEffect, Constraint ... constraints) {
        super("SimpleManagementPermission", actionEffect);
        this.constraints = constraints;
    }

    @Override
    public boolean implies(Permission permission) {
        if (this.equals(permission)) {
            SimpleManagementPermission other = (SimpleManagementPermission)permission;
            assert (this.constraints.length == other.constraints.length) : String.format("incompatible ManagementPermission; differing constraint counts %d vs %d", this.constraints.length, other.constraints.length);
            Action.ActionEffect actionEffect = this.getActionEffect();
            for (int i = 0; i < this.constraints.length; ++i) {
                Constraint ours = this.constraints[i];
                Constraint theirs = other.constraints[i];
                assert (ours.getClass() == theirs.getClass()) : "incompatible constraints: ours = " + ours.getClass() + " -- theirs = " + theirs.getClass();
                if (!ours.violates(theirs, actionEffect)) continue;
                ControllerLogger.ACCESS_LOGGER.tracef("Constraints are violated for %s", (Object)actionEffect);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagementPermission that = (ManagementPermission)o;
        return this.getActionEffect() == that.getActionEffect();
    }

    @Override
    public int hashCode() {
        return this.getActionEffect().hashCode();
    }

    @Override
    public String getActions() {
        return this.getActionEffect().toString();
    }

    public ManagementPermission createScopedPermission(Constraint constraint, int constraintIndex) {
        Constraint[] altered;
        if (constraintIndex == this.constraints.length) {
            altered = new Constraint[constraintIndex + 1];
            System.arraycopy(this.constraints, 0, altered, 0, this.constraints.length);
        } else {
            Constraint existing = this.constraints[constraintIndex];
            if (constraint.replaces(existing)) {
                altered = new Constraint[this.constraints.length];
                System.arraycopy(this.constraints, 0, altered, 0, this.constraints.length);
            } else {
                altered = new Constraint[constraintIndex + 1];
                if (constraintIndex == 0) {
                    System.arraycopy(this.constraints, 0, altered, 1, this.constraints.length);
                } else {
                    System.arraycopy(this.constraints, 0, altered, 0, constraintIndex);
                    System.arraycopy(this.constraints, constraintIndex, altered, constraintIndex + 1, this.constraints.length - constraintIndex);
                }
            }
        }
        altered[constraintIndex] = constraint;
        return new SimpleManagementPermission(this.getActionEffect(), altered);
    }
}

