/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public final class StringListAttributeDefinition
extends PrimitiveListAttributeDefinition {
    private StringListAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpressions, int minSize, int maxSize, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, Boolean nullSignificant, AttributeAccess.Flag ... flags) {
        super(name, xmlName, allowNull, allowExpressions, ModelType.STRING, minSize, maxSize, elementValidator, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, nullSignificant, flags);
    }

    public List<String> unwrap(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.hasDefined(this.getName())) {
            return null;
        }
        ModelNode modelProps = model.get(this.getName());
        LinkedList<String> result = new LinkedList<String>();
        for (ModelNode p : modelProps.asList()) {
            result.add(context.resolveExpressions(p).asString());
        }
        return result;
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, StringListAttributeDefinition> {
        public Builder(String name) {
            super(name, ModelType.STRING);
            this.validator = new ModelTypeValidator(ModelType.STRING);
        }

        public Builder(StringListAttributeDefinition basic) {
            super(basic);
            if (this.validator == null) {
                this.validator = new ModelTypeValidator(ModelType.STRING);
            }
        }

        @Override
        public StringListAttributeDefinition build() {
            return new StringListAttributeDefinition(this.name, this.xmlName, this.allowNull, this.allowExpression, this.minSize, this.maxSize, this.validator, this.alternatives, this.requires, this.attributeMarshaller, this.resourceOnly, this.deprecated, this.accessConstraints, this.nullSignficant, this.flags);
        }
    }
}

