/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public final class PropertiesAttributeDefinition
extends MapAttributeDefinition {
    @Deprecated
    public PropertiesAttributeDefinition(String name, String xmlName, boolean allowNull) {
        super(name, xmlName, allowNull, 0, Integer.MAX_VALUE, new ModelTypeValidator(ModelType.STRING));
    }

    private PropertiesAttributeDefinition(String name, String xmlName, boolean allowNull, boolean allowExpression, int minSize, int maxSize, ParameterCorrector corrector, ParameterValidator elementValidator, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, Boolean nullSignificant, AttributeAccess.Flag ... flags) {
        super(name, xmlName, allowNull, allowExpression, minSize, maxSize, corrector, elementValidator, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, nullSignificant, flags);
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        this.setValueType(node);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.setValueType(node);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        this.setValueType(node);
    }

    void setValueType(ModelNode node) {
        node.get("value-type").set(ModelType.STRING);
        if (this.isAllowExpression()) {
            node.get("expressions-allowed").set(new ModelNode(true));
        }
    }

    public Map<String, String> unwrap(OperationContext context, ModelNode model) throws OperationFailedException {
        if (!model.hasDefined(this.getName())) {
            return new HashMap<String, String>();
        }
        ModelNode modelProps = model.get(this.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property p : modelProps.asPropertyList()) {
            props.put(p.getName(), context.resolveExpressions(p.getValue()).asString());
        }
        return props;
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, PropertiesAttributeDefinition> {
        private boolean wrapXmlElement = true;
        private String wrapperElement = null;

        public Builder(String name, boolean allowNull) {
            super(name, ModelType.OBJECT, allowNull);
        }

        public Builder(PropertiesAttributeDefinition basis) {
            super(basis);
        }

        public Builder(MapAttributeDefinition basis) {
            super(basis);
        }

        public Builder setWrapXmlElement(boolean wrap) {
            this.wrapXmlElement = wrap;
            return this;
        }

        public Builder setWrapperElement(String name) {
            this.wrapperElement = name;
            return this;
        }

        @Override
        public PropertiesAttributeDefinition build() {
            if (this.validator == null) {
                this.validator = new ModelTypeValidator(ModelType.STRING, this.allowNull, this.allowExpression);
            }
            if (this.attributeMarshaller == null) {
                this.attributeMarshaller = new PropertiesAttributeMarshaller(this.wrapXmlElement, this.wrapperElement);
            }
            return new PropertiesAttributeDefinition(this.name, this.xmlName, this.allowNull, this.allowExpression, this.minSize, this.maxSize, this.corrector, this.validator, this.alternatives, this.requires, this.attributeMarshaller, this.resourceOnly, this.deprecated, this.accessConstraints, this.nullSignficant, this.flags);
        }
    }

    private static class PropertiesAttributeMarshaller
    extends AttributeMarshaller {
        private final boolean wrapElement;
        private final String wrapperElement;

        protected PropertiesAttributeMarshaller(boolean wrapElement, String wrapperElement) {
            this.wrapElement = wrapElement;
            this.wrapperElement = wrapperElement;
        }

        @Override
        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.isDefined() && resourceModel.hasDefined(attribute.getName());
        }

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            resourceModel = resourceModel.get(attribute.getName());
            if (this.wrapElement) {
                writer.writeStartElement(this.wrapperElement == null ? attribute.getName() : this.wrapperElement);
            }
            for (ModelNode property : resourceModel.asList()) {
                writer.writeEmptyElement(attribute.getXmlName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.asProperty().getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), property.asProperty().getValue().asString());
            }
            if (this.wrapElement) {
                writer.writeEndElement();
            }
        }
    }
}

