/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.gdata;

import com.google.gdata.client.Query;
import com.google.gdata.client.spreadsheet.FeedURLFactory;
import com.google.gdata.client.spreadsheet.SpreadsheetQuery;
import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.SpreadsheetFeed;
import java.util.List;
import org.teiid.resource.adapter.google.auth.AuthHeaderFactory;
import org.teiid.resource.adapter.google.common.GDataAPI;
import org.teiid.resource.adapter.google.common.SpreadsheetOperationException;

public class GDataClientLoginAPI
implements GDataAPI {
    private static final int RETRY_DELAY = 3000;
    private SpreadsheetService service = new SpreadsheetService("GdataSpreadsheetBrowser");
    private FeedURLFactory factory = FeedURLFactory.getDefault();
    private AuthHeaderFactory headerFactory = null;

    public void setHeaderFactory(AuthHeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
        this.service.setHeader("Authorization", headerFactory.getAuthHeader());
    }

    public SpreadsheetEntry getSpreadsheetEntryByTitle(String sheetTitle) {
        SpreadsheetQuery squery = new SpreadsheetQuery(this.factory.getSpreadsheetsFeedUrl());
        squery.setTitleExact(true);
        squery.setTitleQuery(sheetTitle);
        SpreadsheetFeed feed = this.getSpreadsheetFeedQuery(squery);
        List entry = feed.getEntries();
        if (entry.size() == 0) {
            throw new SpreadsheetOperationException("Couldn't find spreadsheet:" + sheetTitle);
        }
        return (SpreadsheetEntry)entry.get(0);
    }

    @Override
    public String getSpreadsheetKeyByTitle(String sheetName) {
        return this.getSpreadsheetEntryByTitle(sheetName).getKey();
    }

    private SpreadsheetFeed getSpreadsheetFeedQuery(SpreadsheetQuery squery) {
        try {
            return (SpreadsheetFeed)this.service.getFeed((Query)squery, SpreadsheetFeed.class);
        }
        catch (Exception ex) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.headerFactory.login();
            this.service.setHeader("Authorization", this.headerFactory.getAuthHeader());
            try {
                return (SpreadsheetFeed)this.service.getFeed((Query)squery, SpreadsheetFeed.class);
            }
            catch (Exception ex2) {
                throw new SpreadsheetOperationException("Error getting spreadsheet feed. Possibly bad authentication or connection problems. " + ex2);
            }
        }
    }
}

