/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.teiid.adminapi.AdminObject;

public abstract class AdminObjectImpl
implements AdminObject,
Serializable {
    private static final long serialVersionUID = -6381303538713462682L;
    private String name;
    private String serverGroup;
    private String serverName;
    private String hostName;
    private Map<String, String> properties = Collections.synchronizedMap(new LinkedHashMap(2));
    protected transient Map<Class<?>, Object> attachments = Collections.synchronizedMap(new HashMap(2));

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setServerGroup(String group) {
        this.serverGroup = group;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public void setHostName(String name) {
        this.hostName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        Map<String, String> map = this.properties;
        synchronized (map) {
            props.putAll(this.properties);
        }
        return props;
    }

    public void setProperties(Properties props) {
        this.properties.clear();
        if (props != null && !props.isEmpty()) {
            for (String key : props.stringPropertyNames()) {
                this.addProperty(key, props.getProperty(key));
            }
        }
    }

    public Map<String, String> getPropertiesMap() {
        return this.properties;
    }

    @Override
    public String getPropertyValue(String key) {
        return this.properties.get(key);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public <T> T addAttchment(Class<T> type, T attachment) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.put(type, attachment);
        return type.cast(result);
    }

    public <T> T removeAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.remove(type);
        return type.cast(result);
    }

    public <T> T getAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        Object result = this.attachments.get(type);
        return type.cast(result);
    }
}

