/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ws;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.resource.cci.ConnectionFactory;
import javax.xml.ws.Service;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.language.Call;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.WSConnection;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSDLMetadataProcessor;
import org.teiid.translator.ws.WSProcedureExecution;
import org.teiid.translator.ws.WSWSDLProcedureExecution;

@Translator(name="ws", description="A translator for making Web Service calls")
public class WSExecutionFactory
extends ExecutionFactory<ConnectionFactory, WSConnection> {
    static final String INVOKE = "invoke";
    static final String INVOKE_HTTP = "invokeHttp";
    public static BundleUtil UTIL = BundleUtil.getBundleUtil(WSExecutionFactory.class);
    private Service.Mode defaultServiceMode = Service.Mode.PAYLOAD;
    private Binding defaultBinding = Binding.SOAP12;
    private String xmlParamName;

    public WSExecutionFactory() {
        this.setSourceRequiredForMetadata(true);
    }

    @TranslatorProperty(description="Contols request/response message wrapping - set to MESSAGE for full control over SOAP messages.", display="Default Service Mode")
    public Service.Mode getDefaultServiceMode() {
        return this.defaultServiceMode;
    }

    public void setDefaultServiceMode(Service.Mode mode) {
        this.defaultServiceMode = mode;
    }

    @TranslatorProperty(description="Contols what SOAP or HTTP type of invocation will be used if none is specified.", display="Default Binding")
    public Binding getDefaultBinding() {
        return this.defaultBinding;
    }

    public void setDefaultBinding(Binding defaultInvocationType) {
        this.defaultBinding = defaultInvocationType;
    }

    @TranslatorProperty(description="Used with the HTTP binding (typically with the GET method) to indicate that the request document should be part of the query string.", display="XML Param Name")
    public String getXMLParamName() {
        return this.xmlParamName;
    }

    public void setXMLParamName(String xmlParamName) {
        this.xmlParamName = xmlParamName;
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        if (command.getProcedureName().equalsIgnoreCase(INVOKE_HTTP)) {
            return new BinaryWSProcedureExecution(command, metadata, executionContext, this, connection);
        }
        if (command.getArguments().size() > 2 || command.getProcedureName().equalsIgnoreCase(INVOKE)) {
            return new WSProcedureExecution(command, metadata, executionContext, this, connection);
        }
        return new WSWSDLProcedureExecution(command, metadata, executionContext, this, connection);
    }

    public final List<String> getSupportedFunctions() {
        return Collections.emptyList();
    }

    public void getMetadata(MetadataFactory metadataFactory, WSConnection conn) throws TranslatorException {
        Procedure p = metadataFactory.addProcedure(INVOKE);
        p.setAnnotation("Invokes a webservice that returns an XML result");
        metadataFactory.addProcedureParameter("result", "xml", ProcedureParameter.Type.ReturnValue, p);
        ProcedureParameter param = metadataFactory.addProcedureParameter("binding", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The invocation binding (HTTP, SOAP11, SOAP12).  May be set or allowed to default to null to use the default binding.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("action", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("With a SOAP invocation, action sets the SOAPAction.  With HTTP it sets the HTTP Method (GET, POST - default, etc.).");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("request", "xml", ProcedureParameter.Type.In, p);
        param.setAnnotation("The XML document or root element that represents the request.  If the ExecutionFactory is configured in with a DefaultServiceMode of MESSAGE, then the SOAP request must contain the entire SOAP message.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("endpoint", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The relative or abolute endpoint to use.  May be set or allowed to default to null to use the default endpoint address.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("stream", "boolean", ProcedureParameter.Type.In, p);
        param.setAnnotation("If the result should be streamed.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param.setDefaultValue("false");
        p = metadataFactory.addProcedure(INVOKE_HTTP);
        p.setAnnotation("Invokes a webservice that returns an binary result");
        metadataFactory.addProcedureParameter("result", "blob", ProcedureParameter.Type.ReturnValue, p);
        param = metadataFactory.addProcedureParameter("action", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("Sets the HTTP Method (GET, POST - default, etc.).");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("request", "object", ProcedureParameter.Type.In, p);
        param.setAnnotation("The String, XML, BLOB, or CLOB value containing a payload (only for POST).");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("endpoint", "string", ProcedureParameter.Type.In, p);
        param.setAnnotation("The relative or abolute endpoint to use.  May be set or allowed to default to null to use the default endpoint address.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param = metadataFactory.addProcedureParameter("stream", "boolean", ProcedureParameter.Type.In, p);
        param.setAnnotation("If the result should be streamed.");
        param.setNullType(BaseColumn.NullType.Nullable);
        param.setDefaultValue("false");
        metadataFactory.addProcedureParameter("contentType", "string", ProcedureParameter.Type.Out, p);
        if (conn != null && conn.getWsdl() != null) {
            WSDLMetadataProcessor metadataProcessor = new WSDLMetadataProcessor(conn.getWsdl().toString());
            PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)metadataFactory.getModelProperties(), (String)"importer");
            metadataProcessor.getMetadata(metadataFactory, conn);
        }
    }

    public boolean areLobsUsableAfterClose() {
        return true;
    }

    public static enum Event implements BundleUtil.Event
    {
        TEIID15001,
        TEIID15002,
        TEIID15003,
        TEIID15004,
        TEIID15005;

    }

    public static enum Binding {
        HTTP("http://www.w3.org/2004/08/wsdl/http"),
        SOAP11("http://schemas.xmlsoap.org/wsdl/soap/http"),
        SOAP12("http://www.w3.org/2003/05/soap/bindings/HTTP/");

        private String bindingId;

        private Binding(String bindingId) {
            this.bindingId = bindingId;
        }

        public String getBindingId() {
            return this.bindingId;
        }
    }
}

