/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.teiid.adminapi.AdminPlugin;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.VDBImport;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.EntryMetaData;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.types.XMLType;
import org.xml.sax.SAXException;

public class VDBMetadataParser {
    private boolean writePropertyElements;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VDBMetaData unmarshell(InputStream content) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLType.getXmlInputFactory();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(content);
        try {
            if (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case VDB: {
                        VDBMetaData vdb = new VDBMetaData();
                        Properties props = VDBMetadataParser.getAttributes(reader);
                        vdb.setName(props.getProperty(Element.NAME.getLocalName()));
                        vdb.setVersion(Integer.parseInt(props.getProperty(Element.VERSION.getLocalName())));
                        VDBMetadataParser.parseVDB(reader, vdb);
                        VDBMetaData vDBMetaData = vdb;
                        return vDBMetaData;
                    }
                }
                throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element1", new Object[]{reader.getName(), Element.VDB.getLocalName()}), reader.getLocation());
            }
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                Logger.getLogger(VDBMetadataParser.class.getName()).log(Level.FINE, "Exception closing vdb stream", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(InputStream content) throws SAXException, IOException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(VDBMetaData.class.getResource("/vdb-deployer.xsd"));
            Validator v = schema.newValidator();
            v.validate(new StreamSource(content));
        }
        finally {
            content.close();
        }
    }

    private static void parseVDB(XMLStreamReader reader, VDBMetaData vdb) throws XMLStreamException {
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    vdb.setDescription(reader.getElementText());
                    continue block10;
                }
                case CONNECTION_TYPE: {
                    vdb.setConnectionType(reader.getElementText());
                    continue block10;
                }
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, vdb);
                    continue block10;
                }
                case MODEL: {
                    ModelMetaData model = new ModelMetaData();
                    VDBMetadataParser.parseModel(reader, model);
                    vdb.addModel(model);
                    continue block10;
                }
                case TRANSLATOR: {
                    VDBTranslatorMetaData translator = new VDBTranslatorMetaData();
                    VDBMetadataParser.parseTranslator(reader, translator);
                    vdb.addOverideTranslator(translator);
                    continue block10;
                }
                case DATA_ROLE: {
                    DataPolicyMetadata policy = new DataPolicyMetadata();
                    VDBMetadataParser.parseDataRole(reader, policy);
                    vdb.addDataPolicy(policy);
                    continue block10;
                }
                case IMPORT_VDB: {
                    VDBImportMetadata vdbImport = new VDBImportMetadata();
                    Properties props = VDBMetadataParser.getAttributes(reader);
                    vdbImport.setName(props.getProperty(Element.NAME.getLocalName()));
                    vdbImport.setVersion(Integer.parseInt(props.getProperty(Element.VERSION.getLocalName())));
                    vdbImport.setImportDataPolicies(Boolean.parseBoolean(props.getProperty(Element.IMPORT_POLICIES.getLocalName(), "true")));
                    vdb.getVDBImports().add(vdbImport);
                    VDBMetadataParser.ignoreTillEnd(reader);
                    continue block10;
                }
                case ENTRY: {
                    EntryMetaData entry = new EntryMetaData();
                    VDBMetadataParser.parseEntry(reader, entry);
                    vdb.getEntries().add(entry);
                    continue block10;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element5", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PROPERTY.getLocalName(), Element.MODEL.getLocalName(), Element.TRANSLATOR.getLocalName(), Element.DATA_ROLE.getLocalName()}), reader.getLocation());
        }
    }

    private static void ignoreTillEnd(XMLStreamReader reader) throws XMLStreamException {
        while (reader.nextTag() != 2) {
        }
    }

    private static void parseProperty(XMLStreamReader reader, AdminObjectImpl anObj) throws XMLStreamException {
        boolean text = false;
        if (reader.getAttributeCount() > 0) {
            String key = null;
            String value = null;
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                if (attrName.equals(Element.NAME.getLocalName())) {
                    key = attrValue;
                    continue;
                }
                if (!attrName.equals(Element.VALUE.getLocalName())) continue;
                value = attrValue;
            }
            if (value == null) {
                value = reader.getElementText();
                text = true;
            }
            anObj.addProperty(key, value);
        }
        if (!text) {
            VDBMetadataParser.ignoreTillEnd(reader);
        }
    }

    private static void parseDataRole(XMLStreamReader reader, DataPolicyMetadata policy) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        policy.setName(props.getProperty(Element.NAME.getLocalName()));
        policy.setAnyAuthenticated(Boolean.parseBoolean(props.getProperty(Element.DATA_ROLE_ANY_ATHENTICATED_ATTR.getLocalName())));
        policy.setAllowCreateTemporaryTables(Boolean.parseBoolean(props.getProperty(Element.DATA_ROLE_ALLOW_TEMP_TABLES_ATTR.getLocalName())));
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    policy.setDescription(reader.getElementText());
                    continue block5;
                }
                case PERMISSION: {
                    DataPolicyMetadata.PermissionMetaData permission = new DataPolicyMetadata.PermissionMetaData();
                    VDBMetadataParser.parsePermission(reader, permission);
                    policy.addPermission(permission);
                    continue block5;
                }
                case MAPPED_ROLE_NAME: {
                    policy.addMappedRoleName(reader.getElementText());
                    continue block5;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element2", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PERMISSION.getLocalName(), Element.MAPPED_ROLE_NAME.getLocalName()}), reader.getLocation());
        }
    }

    private static void parsePermission(XMLStreamReader reader, DataPolicyMetadata.PermissionMetaData permission) throws XMLStreamException {
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case RESOURCE_NAME: {
                    permission.setResourceName(reader.getElementText());
                    continue block12;
                }
                case ALLOW_ALTER: {
                    permission.setAllowAlter(Boolean.parseBoolean(reader.getElementText()));
                    continue block12;
                }
                case ALLOW_CREATE: {
                    permission.setAllowCreate(Boolean.parseBoolean(reader.getElementText()));
                    continue block12;
                }
                case ALLOW_LANGUAGE: {
                    permission.setAllowLanguage(Boolean.parseBoolean(reader.getElementText()));
                    continue block12;
                }
                case ALLOW_DELETE: {
                    permission.setAllowDelete(Boolean.parseBoolean(reader.getElementText()));
                    continue block12;
                }
                case ALLOW_EXECUTE: {
                    permission.setAllowExecute(Boolean.parseBoolean(reader.getElementText()));
                    continue block12;
                }
                case ALLOW_READ: {
                    permission.setAllowRead(Boolean.parseBoolean(reader.getElementText()));
                    continue block12;
                }
                case ALLOW_UPADTE: {
                    permission.setAllowUpdate(Boolean.parseBoolean(reader.getElementText()));
                    continue block12;
                }
                case CONDITION: {
                    if (reader.getAttributeCount() > 0) {
                        permission.setConstraint(Boolean.valueOf(reader.getAttributeValue(0)));
                    }
                    permission.setCondition(reader.getElementText());
                    continue block12;
                }
                case MASK: {
                    if (reader.getAttributeCount() > 0) {
                        permission.setOrder(Integer.valueOf(reader.getAttributeValue(0)));
                    }
                    permission.setMask(reader.getElementText());
                    continue block12;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element7", new Object[]{reader.getName(), Element.RESOURCE_NAME.getLocalName(), Element.ALLOW_ALTER.getLocalName(), Element.ALLOW_CREATE.getLocalName(), Element.ALLOW_DELETE.getLocalName(), Element.ALLOW_EXECUTE.getLocalName(), Element.ALLOW_READ.getLocalName(), Element.ALLOW_UPADTE.getLocalName(), Element.ALLOW_LANGUAGE.getLocalName(), Element.CONSTRAINT.getLocalName(), Element.CONDITION.getLocalName(), Element.MASK.getLocalName()}), reader.getLocation());
        }
    }

    private static void parseTranslator(XMLStreamReader reader, VDBTranslatorMetaData translator) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        translator.setName(props.getProperty(Element.NAME.getLocalName()));
        translator.setType(props.getProperty(Element.TYPE.getLocalName()));
        translator.setDescription(props.getProperty(Element.DESCRIPTION.getLocalName()));
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, translator);
                    continue block3;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element1", new Object[]{reader.getName(), Element.PROPERTY.getLocalName()}), reader.getLocation());
        }
    }

    private static void parseEntry(XMLStreamReader reader, EntryMetaData entry) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        entry.setPath(props.getProperty(Element.PATH.getLocalName()));
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    entry.setDescription(reader.getElementText());
                    continue block4;
                }
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, entry);
                    continue block4;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element2", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PROPERTY.getLocalName()}));
        }
    }

    private static void parseModel(XMLStreamReader reader, ModelMetaData model) throws XMLStreamException {
        Properties props = VDBMetadataParser.getAttributes(reader);
        model.setName(props.getProperty(Element.NAME.getLocalName()));
        model.setModelType(props.getProperty(Element.TYPE.getLocalName(), "PHYSICAL"));
        model.setVisible(Boolean.parseBoolean(props.getProperty(Element.VISIBLE.getLocalName(), "true")));
        model.setPath(props.getProperty(Element.PATH.getLocalName()));
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DESCRIPTION: {
                    model.setDescription(reader.getElementText());
                    continue block7;
                }
                case PROPERTY: {
                    VDBMetadataParser.parseProperty(reader, model);
                    continue block7;
                }
                case SOURCE: {
                    Properties sourceProps = VDBMetadataParser.getAttributes(reader);
                    String name = sourceProps.getProperty(Element.NAME.getLocalName());
                    String translatorName = sourceProps.getProperty(Element.SOURCE_TRANSLATOR_NAME_ATTR.getLocalName());
                    String connectionName = sourceProps.getProperty(Element.SOURCE_CONNECTION_JNDI_NAME_ATTR.getLocalName());
                    model.addSourceMapping(name, translatorName, connectionName);
                    VDBMetadataParser.ignoreTillEnd(reader);
                    continue block7;
                }
                case VALIDATION_ERROR: {
                    Properties validationProps = VDBMetadataParser.getAttributes(reader);
                    String msg = reader.getElementText();
                    String severity = validationProps.getProperty(Element.VALIDATION_SEVERITY_ATTR.getLocalName());
                    String path = validationProps.getProperty(Element.PATH.getLocalName());
                    ModelMetaData.Message ve = new ModelMetaData.Message(ModelMetaData.Message.Severity.valueOf(severity), msg);
                    ve.setPath(path);
                    model.addMessage(ve);
                    continue block7;
                }
                case METADATA: {
                    Properties metdataProps = VDBMetadataParser.getAttributes(reader);
                    String type = metdataProps.getProperty(Element.TYPE.getLocalName(), "DDL");
                    String schema = reader.getElementText();
                    model.setSchemaSourceType(type);
                    model.setSchemaText(schema);
                    continue block7;
                }
            }
            throw new XMLStreamException(AdminPlugin.Util.gs("unexpected_element5", new Object[]{reader.getName(), Element.DESCRIPTION.getLocalName(), Element.PROPERTY.getLocalName(), Element.SOURCE.getLocalName(), Element.METADATA.getLocalName(), Element.VALIDATION_ERROR.getLocalName()}), reader.getLocation());
        }
    }

    private static Properties getAttributes(XMLStreamReader reader) {
        Properties props = new Properties();
        if (reader.getAttributeCount() > 0) {
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attrName = reader.getAttributeLocalName(i);
                String attrValue = reader.getAttributeValue(i);
                props.setProperty(attrName, attrValue);
            }
        }
        return props;
    }

    public static void marshell(VDBMetaData vdb, OutputStream out) throws XMLStreamException, IOException {
        VDBMetadataParser parser = new VDBMetadataParser();
        parser.writeVDB(vdb, out);
    }

    private void writeVDB(VDBMetaData vdb, OutputStream out) throws XMLStreamException, IOException {
        XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(out);
        writer.writeStartDocument();
        writer.writeStartElement(Element.VDB.getLocalName());
        this.writeAttribute(writer, Element.NAME.getLocalName(), vdb.getName());
        this.writeAttribute(writer, Element.VERSION.getLocalName(), String.valueOf(vdb.getVersion()));
        if (vdb.getDescription() != null) {
            this.writeElement(writer, Element.DESCRIPTION, vdb.getDescription(), new String[0][]);
        }
        this.writeElement(writer, Element.CONNECTION_TYPE, vdb.getConnectionType().name(), new String[0][]);
        this.writeProperties(writer, vdb.getPropertiesMap());
        for (VDBImport vDBImport : vdb.getVDBImports()) {
            writer.writeStartElement(Element.IMPORT_VDB.getLocalName());
            this.writeAttribute(writer, Element.NAME.getLocalName(), vDBImport.getName());
            this.writeAttribute(writer, Element.VERSION.getLocalName(), String.valueOf(vDBImport.getVersion()));
            this.writeAttribute(writer, Element.IMPORT_POLICIES.getLocalName(), String.valueOf(vDBImport.isImportDataPolicies()));
            writer.writeEndElement();
        }
        Collection<ModelMetaData> models = vdb.getModelMetaDatas().values();
        for (ModelMetaData model : models) {
            if (vdb.getImportedModels().contains(model.getName())) continue;
            this.writeModel(writer, model);
        }
        for (VDBTranslatorMetaData translator : vdb.getOverrideTranslatorsMap().values()) {
            this.writeTranslator(writer, translator);
        }
        for (DataPolicy dp : vdb.getDataPolicies()) {
            this.writeDataPolicy(writer, dp);
        }
        for (EntryMetaData em : vdb.getEntries()) {
            writer.writeStartElement(Element.ENTRY.getLocalName());
            this.writeAttribute(writer, Element.PATH.getLocalName(), em.getPath());
            if (em.getDescription() != null) {
                this.writeElement(writer, Element.DESCRIPTION, em.getDescription(), new String[0][]);
            }
            this.writeProperties(writer, em.getPropertiesMap());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        out.close();
    }

    private void writeDataPolicy(XMLStreamWriter writer, DataPolicy dp) throws XMLStreamException {
        writer.writeStartElement(Element.DATA_ROLE.getLocalName());
        this.writeAttribute(writer, Element.NAME.getLocalName(), dp.getName());
        this.writeAttribute(writer, Element.DATA_ROLE_ANY_ATHENTICATED_ATTR.getLocalName(), String.valueOf(dp.isAnyAuthenticated()));
        this.writeAttribute(writer, Element.DATA_ROLE_ALLOW_TEMP_TABLES_ATTR.getLocalName(), String.valueOf(dp.isAllowCreateTemporaryTables()));
        this.writeElement(writer, Element.DESCRIPTION, dp.getDescription(), new String[0][]);
        for (DataPolicy.DataPermission permission : dp.getPermissions()) {
            writer.writeStartElement(Element.PERMISSION.getLocalName());
            this.writeElement(writer, Element.RESOURCE_NAME, permission.getResourceName(), new String[0][]);
            if (permission.getAllowCreate() != null) {
                this.writeElement(writer, Element.ALLOW_CREATE, permission.getAllowCreate().toString(), new String[0][]);
            }
            if (permission.getAllowRead() != null) {
                this.writeElement(writer, Element.ALLOW_READ, permission.getAllowRead().toString(), new String[0][]);
            }
            if (permission.getAllowUpdate() != null) {
                this.writeElement(writer, Element.ALLOW_UPADTE, permission.getAllowUpdate().toString(), new String[0][]);
            }
            if (permission.getAllowDelete() != null) {
                this.writeElement(writer, Element.ALLOW_DELETE, permission.getAllowDelete().toString(), new String[0][]);
            }
            if (permission.getAllowExecute() != null) {
                this.writeElement(writer, Element.ALLOW_EXECUTE, permission.getAllowExecute().toString(), new String[0][]);
            }
            if (permission.getAllowAlter() != null) {
                this.writeElement(writer, Element.ALLOW_ALTER, permission.getAllowAlter().toString(), new String[0][]);
            }
            if (permission.getAllowLanguage() != null) {
                this.writeElement(writer, Element.ALLOW_LANGUAGE, permission.getAllowLanguage().toString(), new String[0][]);
            }
            if (permission.getCondition() != null) {
                if (permission.getConstraint() != null) {
                    this.writeElement(writer, Element.CONDITION, permission.getCondition(), new String[][]{{Element.CONSTRAINT.getLocalName(), String.valueOf(permission.getCondition())}});
                } else {
                    this.writeElement(writer, Element.CONDITION, permission.getCondition(), new String[0][]);
                }
            }
            if (permission.getMask() != null) {
                if (permission.getOrder() != null) {
                    this.writeElement(writer, Element.MASK, permission.getMask(), new String[][]{{Element.ORDER.getLocalName(), String.valueOf(permission.getOrder())}});
                } else {
                    this.writeElement(writer, Element.MASK, permission.getMask(), new String[0][]);
                }
            }
            writer.writeEndElement();
        }
        for (String roleName : dp.getMappedRoleNames()) {
            this.writeElement(writer, Element.MAPPED_ROLE_NAME, roleName, new String[0][]);
        }
        writer.writeEndElement();
    }

    private void writeTranslator(XMLStreamWriter writer, VDBTranslatorMetaData translator) throws XMLStreamException {
        writer.writeStartElement(Element.TRANSLATOR.getLocalName());
        this.writeAttribute(writer, Element.NAME.getLocalName(), translator.getName());
        this.writeAttribute(writer, Element.TYPE.getLocalName(), translator.getType());
        this.writeAttribute(writer, Element.DESCRIPTION.getLocalName(), translator.getDescription());
        this.writeProperties(writer, translator.getPropertiesMap());
        writer.writeEndElement();
    }

    private void writeModel(XMLStreamWriter writer, ModelMetaData model) throws XMLStreamException {
        writer.writeStartElement(Element.MODEL.getLocalName());
        this.writeAttribute(writer, Element.NAME.getLocalName(), model.getName());
        this.writeAttribute(writer, Element.TYPE.getLocalName(), model.getModelType().name());
        this.writeAttribute(writer, Element.VISIBLE.getLocalName(), String.valueOf(model.isVisible()));
        this.writeAttribute(writer, Element.PATH.getLocalName(), model.getPath());
        if (model.getDescription() != null) {
            this.writeElement(writer, Element.DESCRIPTION, model.getDescription(), new String[0][]);
        }
        this.writeProperties(writer, model.getPropertiesMap());
        for (SourceMappingMetadata source : model.getSourceMappings()) {
            writer.writeStartElement(Element.SOURCE.getLocalName());
            this.writeAttribute(writer, Element.NAME.getLocalName(), source.getName());
            this.writeAttribute(writer, Element.SOURCE_TRANSLATOR_NAME_ATTR.getLocalName(), source.getTranslatorName());
            this.writeAttribute(writer, Element.SOURCE_CONNECTION_JNDI_NAME_ATTR.getLocalName(), source.getConnectionJndiName());
            writer.writeEndElement();
        }
        if (model.getSchemaSourceType() != null) {
            writer.writeStartElement(Element.METADATA.getLocalName());
            this.writeAttribute(writer, Element.TYPE.getLocalName(), model.getSchemaSourceType());
            writer.writeCData(model.getSchemaText());
            writer.writeEndElement();
        }
        for (ModelMetaData.Message ve : model.getMessages(false)) {
            writer.writeStartElement(Element.VALIDATION_ERROR.getLocalName());
            this.writeAttribute(writer, Element.VALIDATION_SEVERITY_ATTR.getLocalName(), ve.getSeverity().name());
            this.writeAttribute(writer, Element.PATH.getLocalName(), ve.getPath());
            writer.writeCharacters(ve.getValue());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(XMLStreamWriter writer, Map<String, String> props) throws XMLStreamException {
        Map<String, String> map = props;
        synchronized (map) {
            for (Map.Entry<String, String> prop : props.entrySet()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                String key = prop.getKey();
                String value = prop.getValue();
                this.writeAttribute(writer, Element.NAME.getLocalName(), key);
                if (value != null) {
                    if (this.writePropertyElements) {
                        writer.writeCharacters(value);
                    } else {
                        this.writeAttribute(writer, Element.VALUE.getLocalName(), value);
                    }
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeAttribute(XMLStreamWriter writer, String localName, String value) throws XMLStreamException {
        if (value != null) {
            writer.writeAttribute(localName, value);
        }
    }

    private void writeElement(XMLStreamWriter writer, Element element, String value, String[] ... attributes) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        for (String[] attribute : attributes) {
            this.writeAttribute(writer, attribute[0], attribute[1]);
        }
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    static enum Element {
        UNKNOWN(null),
        VDB("vdb"),
        NAME("name"),
        VERSION("version"),
        DESCRIPTION("description"),
        CONNECTION_TYPE("connection-type"),
        PROPERTY("property"),
        VALUE("value"),
        MODEL("model"),
        IMPORT_VDB("import-vdb"),
        IMPORT_POLICIES("import-data-policies"),
        TYPE("type"),
        VISIBLE("visible"),
        PATH("path"),
        SOURCE("source"),
        SOURCE_TRANSLATOR_NAME_ATTR("translator-name"),
        SOURCE_CONNECTION_JNDI_NAME_ATTR("connection-jndi-name"),
        VALIDATION_ERROR("validation-error"),
        VALIDATION_SEVERITY_ATTR("severity"),
        TRANSLATOR("translator"),
        DATA_ROLE("data-role"),
        DATA_ROLE_ANY_ATHENTICATED_ATTR("any-authenticated"),
        DATA_ROLE_ALLOW_TEMP_TABLES_ATTR("allow-create-temporary-tables"),
        PERMISSION("permission"),
        RESOURCE_NAME("resource-name"),
        ALLOW_CREATE("allow-create"),
        ALLOW_READ("allow-read"),
        ALLOW_UPADTE("allow-update"),
        ALLOW_DELETE("allow-delete"),
        ALLOW_EXECUTE("allow-execute"),
        ALLOW_ALTER("allow-alter"),
        ALLOW_LANGUAGE("allow-language"),
        CONDITION("condition"),
        MASK("mask"),
        ORDER("order"),
        CONSTRAINT("constraint"),
        MAPPED_ROLE_NAME("mapped-role-name"),
        ENTRY("entry"),
        METADATA("metadata");

        private final String name;
        private static final Map<String, Element> elements;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = elements.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            elements = map;
        }
    }
}

